/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.encodings;

import com.aspose.cad.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.cad.internal.bouncycastle.crypto.encodings.a;
import com.aspose.cad.internal.bouncycastle.crypto.encodings.b;
import com.aspose.cad.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import java.security.AccessController;
import java.security.SecureRandom;

public class PKCS1Encoding
implements AsymmetricBlockCipher {
    public static final String STRICT_LENGTH_ENABLED_PROPERTY = "com.aspose.cad.internal.bouncycastle.pkcs1.strict";
    public static final String NOT_STRICT_LENGTH_ENABLED_PROPERTY = "com.aspose.cad.internal.bouncycastle.pkcs1.not_strict";
    private static final int a = 10;
    private SecureRandom b;
    private AsymmetricBlockCipher c;
    private boolean d;
    private boolean e;
    private boolean f;
    private int g = -1;
    private byte[] h = null;
    private byte[] i;

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.c = asymmetricBlockCipher;
        this.f = this.a();
    }

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher, int n2) {
        this.c = asymmetricBlockCipher;
        this.f = this.a();
        this.g = n2;
    }

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher, byte[] byArray) {
        this.c = asymmetricBlockCipher;
        this.f = this.a();
        this.h = byArray;
        this.g = byArray.length;
    }

    private boolean a() {
        String string = (String)AccessController.doPrivileged(new a(this));
        String string2 = (String)AccessController.doPrivileged(new b(this));
        if (string2 != null) {
            return !string2.equals("true");
        }
        return string == null || string.equals("true");
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.c;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.b = parametersWithRandom.getRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
            if (!asymmetricKeyParameter.isPrivate() && bl2) {
                this.b = new SecureRandom();
            }
        }
        this.c.init(bl2, cipherParameters);
        this.e = asymmetricKeyParameter.isPrivate();
        this.d = bl2;
        this.i = new byte[this.c.getOutputBlockSize()];
        if (this.g > 0 && this.h == null && this.b == null) {
            throw new IllegalArgumentException("encoder requires random");
        }
    }

    @Override
    public int getInputBlockSize() {
        int n2 = this.c.getInputBlockSize();
        if (this.d) {
            return n2 - 10;
        }
        return n2;
    }

    @Override
    public int getOutputBlockSize() {
        int n2 = this.c.getOutputBlockSize();
        if (this.d) {
            return n2;
        }
        return n2 - 10;
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.d) {
            return this.a(byArray, n2, n3);
        }
        return this.c(byArray, n2, n3);
    }

    private byte[] a(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (n3 > this.getInputBlockSize()) {
            throw new IllegalArgumentException("input data too large");
        }
        byte[] byArray2 = new byte[this.c.getInputBlockSize()];
        if (this.e) {
            byArray2[0] = 1;
            for (int i2 = 1; i2 != byArray2.length - n3 - 1; ++i2) {
                byArray2[i2] = -1;
            }
        } else {
            this.b.nextBytes(byArray2);
            byArray2[0] = 2;
            for (int i3 = 1; i3 != byArray2.length - n3 - 1; ++i3) {
                while (byArray2[i3] == 0) {
                    byArray2[i3] = (byte)this.b.nextInt();
                }
            }
        }
        byArray2[byArray2.length - n3 - 1] = 0;
        System.arraycopy(byArray, n2, byArray2, byArray2.length - n3, n3);
        return this.c.processBlock(byArray2, 0, byArray2.length);
    }

    private static int a(byte[] byArray, int n2) {
        int n3 = 0;
        n3 |= byArray[0] ^ 2;
        int n4 = byArray.length - (n2 + 1);
        for (int i2 = 1; i2 < n4; ++i2) {
            int n5 = byArray[i2];
            n5 |= n5 >> 1;
            n5 |= n5 >> 2;
            n5 |= n5 >> 4;
            n3 |= (n5 & 1) - 1;
        }
        n3 |= byArray[byArray.length - (n2 + 1)];
        n3 |= n3 >> 1;
        n3 |= n3 >> 2;
        n3 |= n3 >> 4;
        return ~((n3 & 1) - 1);
    }

    private byte[] b(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2;
        if (!this.e) {
            throw new InvalidCipherTextException("sorry, this method is only for decryption, not for signing");
        }
        byte[] byArray3 = this.c.processBlock(byArray, n2, n3);
        if (this.h == null) {
            byArray2 = new byte[this.g];
            this.b.nextBytes(byArray2);
        } else {
            byArray2 = this.h;
        }
        byte[] byArray4 = this.f & byArray3.length != this.c.getOutputBlockSize() ? this.i : byArray3;
        int n4 = PKCS1Encoding.a(byArray4, this.g);
        byte[] byArray5 = new byte[this.g];
        for (int i2 = 0; i2 < this.g; ++i2) {
            byArray5[i2] = (byte)(byArray4[i2 + (byArray4.length - this.g)] & ~n4 | byArray2[i2] & n4);
        }
        Arrays.fill(byArray4, (byte)0);
        return byArray5;
    }

    private byte[] c(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.g != -1) {
            return this.b(byArray, n2, n3);
        }
        byte[] byArray2 = this.c.processBlock(byArray, n2, n3);
        boolean bl2 = this.f & byArray2.length != this.c.getOutputBlockSize();
        byte[] byArray3 = byArray2.length < this.getOutputBlockSize() ? this.i : byArray2;
        byte by2 = byArray3[0];
        boolean bl3 = this.e ? by2 != 2 : by2 != 1;
        int n4 = this.a(by2, byArray3);
        if (bl3 | ++n4 < 10) {
            Arrays.fill(byArray3, (byte)0);
            throw new InvalidCipherTextException("block incorrect");
        }
        if (bl2) {
            Arrays.fill(byArray3, (byte)0);
            throw new InvalidCipherTextException("block incorrect size");
        }
        byte[] byArray4 = new byte[byArray3.length - n4];
        System.arraycopy(byArray3, n4, byArray4, 0, byArray4.length);
        return byArray4;
    }

    private int a(byte by2, byte[] byArray) throws InvalidCipherTextException {
        int n2 = -1;
        boolean bl2 = false;
        for (int i2 = 1; i2 != byArray.length; ++i2) {
            byte by3 = byArray[i2];
            if (by3 == 0 & n2 < 0) {
                n2 = i2;
            }
            bl2 |= by2 == 1 & n2 < 0 & by3 != -1;
        }
        if (bl2) {
            return -1;
        }
        return n2;
    }
}

