/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.tls;

import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsFatalAlert;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ServerName {
    protected short nameType;
    protected Object name;

    public ServerName(short s2, Object object) {
        if (!ServerName.isCorrectType(s2, object)) {
            throw new IllegalArgumentException("'name' is not an instance of the correct type");
        }
        this.nameType = s2;
        this.name = object;
    }

    public short getNameType() {
        return this.nameType;
    }

    public Object getName() {
        return this.name;
    }

    public String getHostName() {
        if (!ServerName.isCorrectType((short)0, this.name)) {
            throw new IllegalStateException("'name' is not a HostName string");
        }
        return (String)this.name;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8(this.nameType, outputStream);
        switch (this.nameType) {
            case 0: {
                byte[] byArray = ((String)this.name).getBytes("ASCII");
                if (byArray.length < 1) {
                    throw new TlsFatalAlert(80);
                }
                TlsUtils.writeOpaque16(byArray, outputStream);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static ServerName parse(InputStream inputStream) throws IOException {
        String string;
        short s2 = TlsUtils.readUint8(inputStream);
        switch (s2) {
            case 0: {
                byte[] byArray = TlsUtils.readOpaque16(inputStream);
                if (byArray.length < 1) {
                    throw new TlsFatalAlert(50);
                }
                string = new String(byArray, "ASCII");
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new ServerName(s2, string);
    }

    protected static boolean isCorrectType(short s2, Object object) {
        switch (s2) {
            case 0: {
                return object instanceof String;
            }
        }
        throw new IllegalArgumentException("'nameType' is an unsupported NameType");
    }
}

