/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.modes;

import com.aspose.cad.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.cad.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.modes.AEADBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.params.AEADParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;

public class KCCMBlockCipher
implements AEADBlockCipher {
    private static final int a = 4;
    private static final int b = 8;
    private static final int c = 512;
    private static final int d = 64;
    private BlockCipher e;
    private int f;
    private boolean g;
    private byte[] h;
    private byte[] i;
    private byte[] j;
    private byte[] k;
    private byte[] l;
    private byte[] m;
    private byte[] n;
    private byte[] o;
    private a p = new a();
    private a q = new a();
    private int r = 4;

    private void a(int n2) {
        if (n2 != 4 && n2 != 6 && n2 != 8) {
            throw new IllegalArgumentException("Nb = 4 is recommended by DSTU7624 but can be changed to only 6 or 8 in this implementation");
        }
        this.r = n2;
    }

    public KCCMBlockCipher(BlockCipher blockCipher) {
        this(blockCipher, 4);
    }

    public KCCMBlockCipher(BlockCipher blockCipher, int n2) {
        this.e = blockCipher;
        this.f = blockCipher.getBlockSize();
        this.k = new byte[blockCipher.getBlockSize()];
        this.h = new byte[blockCipher.getBlockSize()];
        this.i = new byte[blockCipher.getBlockSize()];
        this.j = new byte[blockCipher.getBlockSize()];
        this.l = new byte[blockCipher.getBlockSize()];
        this.m = new byte[blockCipher.getBlockSize()];
        this.n = new byte[blockCipher.getBlockSize()];
        this.o = new byte[blockCipher.getBlockSize()];
        this.a(n2);
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof AEADParameters) {
            AEADParameters aEADParameters = (AEADParameters)cipherParameters;
            if (aEADParameters.getMacSize() > 512 || aEADParameters.getMacSize() < 64 || aEADParameters.getMacSize() % 8 != 0) {
                throw new IllegalArgumentException("Invalid mac size specified");
            }
            this.k = aEADParameters.getNonce();
            this.f = aEADParameters.getMacSize() / 8;
            this.h = aEADParameters.getAssociatedText();
            cipherParameters2 = aEADParameters.getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            this.k = ((ParametersWithIV)cipherParameters).getIV();
            this.f = this.e.getBlockSize();
            this.h = null;
            cipherParameters2 = ((ParametersWithIV)cipherParameters).getParameters();
        } else {
            throw new IllegalArgumentException("Invalid parameters specified");
        }
        this.i = new byte[this.f];
        this.g = bl2;
        this.e.init(true, cipherParameters2);
        this.o[0] = 1;
        if (this.h != null) {
            this.processAADBytes(this.h, 0, this.h.length);
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.e.getAlgorithmName() + "/KCCM";
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.e;
    }

    @Override
    public void processAADByte(byte by2) {
        this.p.write(by2);
    }

    @Override
    public void processAADBytes(byte[] byArray, int n2, int n3) {
        this.p.write(byArray, n2, n3);
    }

    private void a(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        if (n3 - n2 < this.e.getBlockSize()) {
            throw new IllegalArgumentException("authText buffer too short");
        }
        if (n3 % this.e.getBlockSize() != 0) {
            throw new IllegalArgumentException("padding not supported");
        }
        System.arraycopy(this.k, 0, this.l, 0, this.k.length - this.r - 1);
        this.a(n4, this.m, 0);
        System.arraycopy(this.m, 0, this.l, this.k.length - this.r - 1, 4);
        this.l[this.l.length - 1] = this.a(true, this.f);
        this.e.processBlock(this.l, 0, this.j, 0);
        this.a(n3, this.m, 0);
        if (n3 <= this.e.getBlockSize() - this.r) {
            int n6;
            for (n6 = 0; n6 < n3; ++n6) {
                int n7 = n6 + this.r;
                this.m[n7] = (byte)(this.m[n7] ^ byArray[n2 + n6]);
            }
            for (n6 = 0; n6 < this.e.getBlockSize(); ++n6) {
                int n8 = n6;
                this.j[n8] = (byte)(this.j[n8] ^ this.m[n6]);
            }
            this.e.processBlock(this.j, 0, this.j, 0);
            return;
        }
        for (n5 = 0; n5 < this.e.getBlockSize(); ++n5) {
            int n9 = n5;
            this.j[n9] = (byte)(this.j[n9] ^ this.m[n5]);
        }
        this.e.processBlock(this.j, 0, this.j, 0);
        for (n5 = n3; n5 != 0; n5 -= this.e.getBlockSize()) {
            for (int i2 = 0; i2 < this.e.getBlockSize(); ++i2) {
                int n10 = i2;
                this.j[n10] = (byte)(this.j[n10] ^ byArray[i2 + n2]);
            }
            this.e.processBlock(this.j, 0, this.j, 0);
            n2 += this.e.getBlockSize();
        }
    }

    @Override
    public int processByte(byte by2, byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        this.q.write(by2);
        return 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException, IllegalStateException {
        if (byArray.length < n2 + n3) {
            throw new DataLengthException("input buffer too short");
        }
        this.q.write(byArray, n2, n3);
        return 0;
    }

    public int processPacket(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, InvalidCipherTextException {
        int n5;
        if (byArray.length - n2 < n3) {
            throw new DataLengthException("input buffer too short");
        }
        if (byArray2.length - n4 < n3) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.p.size() > 0) {
            if (this.g) {
                this.a(this.p.a(), 0, this.p.size(), this.q.size());
            } else {
                this.a(this.p.a(), 0, this.p.size(), this.q.size() - this.f);
            }
        }
        if (this.g) {
            int n6;
            if (n3 % this.e.getBlockSize() != 0) {
                throw new DataLengthException("partial blocks not supported");
            }
            this.a(byArray, n2, n3);
            this.e.processBlock(this.k, 0, this.n, 0);
            int n7 = n3;
            while (n7 > 0) {
                this.a(byArray, n2, n3, byArray2, n4);
                n7 -= this.e.getBlockSize();
                n2 += this.e.getBlockSize();
                n4 += this.e.getBlockSize();
            }
            for (n6 = 0; n6 < this.o.length; ++n6) {
                int n8 = n6;
                this.n[n8] = (byte)(this.n[n8] + this.o[n6]);
            }
            this.e.processBlock(this.n, 0, this.m, 0);
            for (n6 = 0; n6 < this.f; ++n6) {
                byArray2[n4 + n6] = (byte)(this.m[n6] ^ this.j[n6]);
            }
            System.arraycopy(this.j, 0, this.i, 0, this.f);
            this.reset();
            return n3 + this.f;
        }
        if ((n3 - this.f) % this.e.getBlockSize() != 0) {
            throw new DataLengthException("partial blocks not supported");
        }
        this.e.processBlock(this.k, 0, this.n, 0);
        int n9 = n3 / this.e.getBlockSize();
        for (n5 = 0; n5 < n9; ++n5) {
            this.a(byArray, n2, n3, byArray2, n4);
            n2 += this.e.getBlockSize();
            n4 += this.e.getBlockSize();
        }
        if (n3 > n2) {
            for (n5 = 0; n5 < this.o.length; ++n5) {
                int n10 = n5;
                this.n[n10] = (byte)(this.n[n10] + this.o[n5]);
            }
            this.e.processBlock(this.n, 0, this.m, 0);
            for (n5 = 0; n5 < this.f; ++n5) {
                byArray2[n4 + n5] = (byte)(this.m[n5] ^ byArray[n2 + n5]);
            }
            n4 += this.f;
        }
        for (n5 = 0; n5 < this.o.length; ++n5) {
            int n11 = n5;
            this.n[n11] = (byte)(this.n[n11] + this.o[n5]);
        }
        this.e.processBlock(this.n, 0, this.m, 0);
        System.arraycopy(byArray2, n4 - this.f, this.m, 0, this.f);
        this.a(byArray2, 0, n4 - this.f);
        System.arraycopy(this.j, 0, this.i, 0, this.f);
        byte[] byArray3 = new byte[this.f];
        System.arraycopy(this.m, 0, byArray3, 0, this.f);
        if (!Arrays.constantTimeAreEqual(this.i, byArray3)) {
            throw new InvalidCipherTextException("mac check failed");
        }
        this.reset();
        return n3 - this.f;
    }

    private void a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5;
        for (n5 = 0; n5 < this.o.length; ++n5) {
            int n6 = n5;
            this.n[n6] = (byte)(this.n[n6] + this.o[n5]);
        }
        this.e.processBlock(this.n, 0, this.m, 0);
        for (n5 = 0; n5 < this.e.getBlockSize(); ++n5) {
            byArray2[n4 + n5] = (byte)(this.m[n5] ^ byArray[n2 + n5]);
        }
    }

    private void a(byte[] byArray, int n2, int n3) {
        int n4 = n3;
        while (n4 > 0) {
            for (int i2 = 0; i2 < this.e.getBlockSize(); ++i2) {
                int n5 = i2;
                this.j[n5] = (byte)(this.j[n5] ^ byArray[n2 + i2]);
            }
            this.e.processBlock(this.j, 0, this.j, 0);
            n4 -= this.e.getBlockSize();
            n2 += this.e.getBlockSize();
        }
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, InvalidCipherTextException {
        int n3 = this.processPacket(this.q.a(), 0, this.q.size(), byArray, n2);
        this.reset();
        return n3;
    }

    @Override
    public byte[] getMac() {
        return Arrays.clone(this.i);
    }

    @Override
    public int getUpdateOutputSize(int n2) {
        return n2;
    }

    @Override
    public int getOutputSize(int n2) {
        return n2 + this.f;
    }

    @Override
    public void reset() {
        Arrays.fill(this.l, (byte)0);
        Arrays.fill(this.m, (byte)0);
        Arrays.fill(this.o, (byte)0);
        Arrays.fill(this.j, (byte)0);
        this.o[0] = 1;
        this.q.reset();
        this.p.reset();
        if (this.h != null) {
            this.processAADBytes(this.h, 0, this.h.length);
        }
    }

    private void a(int n2, byte[] byArray, int n3) {
        byArray[n3 + 3] = (byte)(n2 >> 24);
        byArray[n3 + 2] = (byte)(n2 >> 16);
        byArray[n3 + 1] = (byte)(n2 >> 8);
        byArray[n3] = (byte)n2;
    }

    private byte a(boolean bl2, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        switch (n2) {
            case 8: {
                stringBuffer.append("010");
                break;
            }
            case 16: {
                stringBuffer.append("011");
                break;
            }
            case 32: {
                stringBuffer.append("100");
                break;
            }
            case 48: {
                stringBuffer.append("101");
                break;
            }
            case 64: {
                stringBuffer.append("110");
            }
        }
        String string = Integer.toBinaryString(this.r - 1);
        while (string.length() < 4) {
            string = new StringBuffer(string).insert(0, "0").toString();
        }
        stringBuffer.append(string);
        return (byte)Integer.parseInt(stringBuffer.toString(), 2);
    }

    private class a
    extends ByteArrayOutputStream {
        public byte[] a() {
            return this.buf;
        }
    }
}

