/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cms;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.cad.internal.bouncycastle.asn1.cms.Attribute;
import com.aspose.cad.internal.bouncycastle.asn1.cms.AttributeTable;
import com.aspose.cad.internal.bouncycastle.asn1.cms.AuthenticatedData;
import com.aspose.cad.internal.bouncycastle.asn1.cms.CMSAlgorithmProtection;
import com.aspose.cad.internal.bouncycastle.asn1.cms.CMSAttributes;
import com.aspose.cad.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.cms.CMSException;
import com.aspose.cad.internal.bouncycastle.cms.CMSProcessableByteArray;
import com.aspose.cad.internal.bouncycastle.cms.OriginatorInformation;
import com.aspose.cad.internal.bouncycastle.cms.RecipientInformationStore;
import com.aspose.cad.internal.bouncycastle.cms.e;
import com.aspose.cad.internal.bouncycastle.cms.h;
import com.aspose.cad.internal.bouncycastle.cms.l;
import com.aspose.cad.internal.bouncycastle.cms.o;
import com.aspose.cad.internal.bouncycastle.operator.DigestCalculatorProvider;
import com.aspose.cad.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import com.aspose.cad.internal.bouncycastle.util.Encodable;
import java.io.IOException;
import java.io.InputStream;

public class CMSAuthenticatedData
implements Encodable {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private AlgorithmIdentifier a;
    private ASN1Set b;
    private ASN1Set c;
    private byte[] d;
    private OriginatorInformation e;

    public CMSAuthenticatedData(byte[] byArray) throws CMSException {
        this(o.a(byArray));
    }

    public CMSAuthenticatedData(byte[] byArray, DigestCalculatorProvider digestCalculatorProvider) throws CMSException {
        this(o.a(byArray), digestCalculatorProvider);
    }

    public CMSAuthenticatedData(InputStream inputStream) throws CMSException {
        this(o.a(inputStream));
    }

    public CMSAuthenticatedData(InputStream inputStream, DigestCalculatorProvider digestCalculatorProvider) throws CMSException {
        this(o.a(inputStream), digestCalculatorProvider);
    }

    public CMSAuthenticatedData(ContentInfo contentInfo) throws CMSException {
        this(contentInfo, null);
    }

    public CMSAuthenticatedData(ContentInfo contentInfo, DigestCalculatorProvider digestCalculatorProvider) throws CMSException {
        this.contentInfo = contentInfo;
        AuthenticatedData authenticatedData = AuthenticatedData.getInstance(contentInfo.getContent());
        if (authenticatedData.getOriginatorInfo() != null) {
            this.e = new OriginatorInformation(authenticatedData.getOriginatorInfo());
        }
        ASN1Set aSN1Set = authenticatedData.getRecipientInfos();
        this.a = authenticatedData.getMacAlgorithm();
        this.b = authenticatedData.getAuthAttrs();
        this.d = authenticatedData.getMac().getOctets();
        this.c = authenticatedData.getUnauthAttrs();
        ContentInfo contentInfo2 = authenticatedData.getEncapsulatedContentInfo();
        CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(ASN1OctetString.getInstance(contentInfo2.getContent()).getOctets());
        if (this.b != null) {
            Object object;
            if (digestCalculatorProvider == null) {
                throw new CMSException("a digest calculator provider is required if authenticated attributes are present");
            }
            AttributeTable attributeTable = new AttributeTable(this.b);
            ASN1EncodableVector aSN1EncodableVector = attributeTable.getAll(CMSAttributes.cmsAlgorithmProtect);
            if (aSN1EncodableVector.size() > 1) {
                throw new CMSException("Only one instance of a cmsAlgorithmProtect attribute can be present");
            }
            if (aSN1EncodableVector.size() > 0) {
                object = Attribute.getInstance(aSN1EncodableVector.get(0));
                if (((Attribute)object).getAttrValues().size() != 1) {
                    throw new CMSException("A cmsAlgorithmProtect attribute MUST contain exactly one value");
                }
                CMSAlgorithmProtection cMSAlgorithmProtection = CMSAlgorithmProtection.getInstance(((Attribute)object).getAttributeValues()[0]);
                if (!o.a(cMSAlgorithmProtection.getDigestAlgorithm(), authenticatedData.getDigestAlgorithm())) {
                    throw new CMSException("CMS Algorithm Identifier Protection check failed for digestAlgorithm");
                }
                if (!o.a(cMSAlgorithmProtection.getMacAlgorithm(), this.a)) {
                    throw new CMSException("CMS Algorithm Identifier Protection check failed for macAlgorithm");
                }
            }
            try {
                object = new h.b(digestCalculatorProvider.get(authenticatedData.getDigestAlgorithm()), cMSProcessableByteArray);
                this.recipientInfoStore = h.a(aSN1Set, this.a, (l)object, new e(this));
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMSException("unable to create digest calculator: " + operatorCreationException.getMessage(), operatorCreationException);
            }
        } else {
            h.a a2 = new h.a(this.a, cMSProcessableByteArray);
            this.recipientInfoStore = h.a(aSN1Set, this.a, a2);
        }
    }

    public OriginatorInformation getOriginatorInfo() {
        return this.e;
    }

    public byte[] getMac() {
        return Arrays.clone(this.d);
    }

    private byte[] a(ASN1Encodable aSN1Encodable) throws IOException {
        if (aSN1Encodable != null) {
            return aSN1Encodable.toASN1Primitive().getEncoded();
        }
        return null;
    }

    public AlgorithmIdentifier getMacAlgorithm() {
        return this.a;
    }

    public String getMacAlgOID() {
        return this.a.getAlgorithm().getId();
    }

    public byte[] getMacAlgParams() {
        try {
            return this.a(this.a.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    public AttributeTable getAuthAttrs() {
        if (this.b == null) {
            return null;
        }
        return new AttributeTable(this.b);
    }

    public AttributeTable getUnauthAttrs() {
        if (this.c == null) {
            return null;
        }
        return new AttributeTable(this.c);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }

    public byte[] getContentDigest() {
        if (this.b != null) {
            return ASN1OctetString.getInstance(this.getAuthAttrs().get(CMSAttributes.messageDigest).getAttrValues().getObjectAt(0)).getOctets();
        }
        return null;
    }

    static /* synthetic */ ASN1Set access$000(CMSAuthenticatedData cMSAuthenticatedData) {
        return cMSAuthenticatedData.b;
    }
}

