/*
 * Decompiled with CFR 0.152.
 */
package cpdetector.test;

import cpdetector.test.IStopWatch;

public class StopWatchSimple
implements IStopWatch {
    protected long start;
    protected long allms;
    protected boolean running = false;

    public StopWatchSimple() {
    }

    public StopWatchSimple(boolean start) {
        if (start) {
            this.start();
        }
    }

    public final void reset() {
        this.start = System.currentTimeMillis();
        this.allms = 0L;
    }

    public final boolean start() {
        if (!this.running) {
            this.start = System.currentTimeMillis();
            this.running = true;
            return true;
        }
        return false;
    }

    public long snapShot() {
        long restart = System.currentTimeMillis();
        this.allms += restart - this.start;
        this.start = restart;
        return this.allms;
    }

    public synchronized boolean stop() {
        if (this.running) {
            this.allms += System.currentTimeMillis() - this.start;
            this.running = false;
            return true;
        }
        return false;
    }

    public final long getPureMilliSeconds() {
        if (this.running) {
            this.snapShot();
        }
        return this.allms;
    }

    public String toString() {
        if (this.running) {
            this.snapShot();
        }
        return String.valueOf(this.allms) + " ms";
    }

    public static void main(String[] args) {
        try {
            System.out.println("Stopping the sleep for 5000 ms");
            final StopWatchSimple test = new StopWatchSimple(true);
            Thread.sleep(5000L);
            test.stop();
            System.out.println("Stopped the StopWatch: ");
            System.out.println(((Object)test).toString());
            System.out.println("Stopping the next sleep of 4000 ms (no reset was called!).");
            System.out.println("    test.start():" + test.start());
            Thread.sleep(4000L);
            System.out.println("    test.stop(): " + test.stop());
            System.out.println("Stopped the StopWatch: ");
            System.out.println(((Object)test).toString());
            System.out.println("Calling reset(). ");
            test.reset();
            System.out.println("Stopping a sleep of 3000 ms.");
            System.out.println("    test.start(): " + test.start());
            Thread.sleep(3000L);
            System.out.println("    test.stop(): " + test.stop());
            System.out.println("Stopped the StopWatch: ");
            System.out.println(((Object)test).toString());
            System.out.println("Calling reset()");
            test.reset();
            new Thread(){

                public void run() {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            1.sleep(1500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        test.snapShot();
                        System.out.println(this.getName() + " performed a snapShot on " + test);
                    }
                }
            }.start();
            System.out.println("Stopping a sleep of 10000 ms. A Thread has been started to take 3 snapShots!");
            System.out.println("    test.start(): " + test.start());
            Thread.sleep(10000L);
            System.out.println("    test.stop(): " + test.stop());
            System.out.println("Stopped the StopWatch: ");
            System.out.println(((Object)test).toString());
        }
        catch (Throwable f) {
            f.printStackTrace();
        }
    }
}

