/*
 * Decompiled with CFR 0.152.
 */
package cpdetector.test;

import cpdetector.io.ASCIIDetector;
import cpdetector.io.CodepageDetectorProxy;
import cpdetector.io.JChardetFacade;
import cpdetector.io.ParsingDetector;
import fit.ColumnFixture;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class DetectURLFixture
extends ColumnFixture {
    public String URL;
    CodepageDetectorProxy detector = CodepageDetectorProxy.getInstance();

    public DetectURLFixture() {
        this.detector.add(new ParsingDetector(true));
        this.detector.add(JChardetFacade.getInstance());
        this.detector.add(ASCIIDetector.getInstance());
    }

    public String detectURL() throws Throwable {
        URL document;
        this.URL = this.URL.toLowerCase();
        File f = new File(this.URL);
        System.out.println("Checking file: " + f.getAbsolutePath());
        if (f.exists()) {
            document = f.toURL();
        } else {
            try {
                document = new URL(this.URL);
            }
            catch (MalformedURLException mue) {
                throw new IllegalArgumentException("Could not reach the file or url: " + this.URL + ". Terminating.", mue);
            }
        }
        System.out.println("Testing document: " + document.toExternalForm());
        return this.detector.detectCodepage(document).name().toLowerCase();
    }
}

