/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.pkcs;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class RSAPrivateKeyStructure
extends ASN1Object {
    private int a;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private BigInteger f;
    private BigInteger g;
    private BigInteger h;
    private BigInteger i;
    private ASN1Sequence j = null;

    public static RSAPrivateKeyStructure getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return RSAPrivateKeyStructure.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static RSAPrivateKeyStructure getInstance(Object object) {
        if (object instanceof RSAPrivateKeyStructure) {
            return (RSAPrivateKeyStructure)object;
        }
        if (object instanceof ASN1Sequence) {
            return new RSAPrivateKeyStructure((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public RSAPrivateKeyStructure(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.a = 0;
        this.b = bigInteger;
        this.c = bigInteger2;
        this.d = bigInteger3;
        this.e = bigInteger4;
        this.f = bigInteger5;
        this.g = bigInteger6;
        this.h = bigInteger7;
        this.i = bigInteger8;
    }

    public RSAPrivateKeyStructure(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        BigInteger bigInteger = ((ASN1Integer)enumeration.nextElement()).getValue();
        if (bigInteger.intValue() != 0 && bigInteger.intValue() != 1) {
            throw new IllegalArgumentException("wrong version for RSA private key");
        }
        this.a = bigInteger.intValue();
        this.b = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.c = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.d = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.e = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.f = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.g = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.h = ((ASN1Integer)enumeration.nextElement()).getValue();
        this.i = ((ASN1Integer)enumeration.nextElement()).getValue();
        if (enumeration.hasMoreElements()) {
            this.j = (ASN1Sequence)enumeration.nextElement();
        }
    }

    public int getVersion() {
        return this.a;
    }

    public BigInteger getModulus() {
        return this.b;
    }

    public BigInteger getPublicExponent() {
        return this.c;
    }

    public BigInteger getPrivateExponent() {
        return this.d;
    }

    public BigInteger getPrime1() {
        return this.e;
    }

    public BigInteger getPrime2() {
        return this.f;
    }

    public BigInteger getExponent1() {
        return this.g;
    }

    public BigInteger getExponent2() {
        return this.h;
    }

    public BigInteger getCoefficient() {
        return this.i;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new ASN1Integer(this.getModulus()));
        aSN1EncodableVector.add(new ASN1Integer(this.getPublicExponent()));
        aSN1EncodableVector.add(new ASN1Integer(this.getPrivateExponent()));
        aSN1EncodableVector.add(new ASN1Integer(this.getPrime1()));
        aSN1EncodableVector.add(new ASN1Integer(this.getPrime2()));
        aSN1EncodableVector.add(new ASN1Integer(this.getExponent1()));
        aSN1EncodableVector.add(new ASN1Integer(this.getExponent2()));
        aSN1EncodableVector.add(new ASN1Integer(this.getCoefficient()));
        if (this.j != null) {
            aSN1EncodableVector.add(this.j);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

