/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.esf;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.esf.OtherRevVals;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import com.aspose.cad.internal.bouncycastle.asn1.x509.CertificateList;
import java.util.Enumeration;

public class RevocationValues
extends ASN1Object {
    private ASN1Sequence a;
    private ASN1Sequence b;
    private OtherRevVals c;

    public static RevocationValues getInstance(Object object) {
        if (object instanceof RevocationValues) {
            return (RevocationValues)object;
        }
        if (object != null) {
            return new RevocationValues(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private RevocationValues(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        block5: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1TaggedObject.getObject();
                    Enumeration enumeration2 = aSN1Sequence2.getObjects();
                    while (enumeration2.hasMoreElements()) {
                        CertificateList.getInstance(enumeration2.nextElement());
                    }
                    this.a = aSN1Sequence2;
                    continue block5;
                }
                case 1: {
                    ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1TaggedObject.getObject();
                    Enumeration enumeration3 = aSN1Sequence3.getObjects();
                    while (enumeration3.hasMoreElements()) {
                        BasicOCSPResponse.getInstance(enumeration3.nextElement());
                    }
                    this.b = aSN1Sequence3;
                    continue block5;
                }
                case 2: {
                    this.c = OtherRevVals.getInstance(aSN1TaggedObject.getObject());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("invalid tag: " + aSN1TaggedObject.getTagNo());
        }
    }

    public RevocationValues(CertificateList[] certificateListArray, BasicOCSPResponse[] basicOCSPResponseArray, OtherRevVals otherRevVals) {
        if (null != certificateListArray) {
            this.a = new DERSequence(certificateListArray);
        }
        if (null != basicOCSPResponseArray) {
            this.b = new DERSequence(basicOCSPResponseArray);
        }
        this.c = otherRevVals;
    }

    public CertificateList[] getCrlVals() {
        if (null == this.a) {
            return new CertificateList[0];
        }
        CertificateList[] certificateListArray = new CertificateList[this.a.size()];
        for (int i2 = 0; i2 < certificateListArray.length; ++i2) {
            certificateListArray[i2] = CertificateList.getInstance(this.a.getObjectAt(i2));
        }
        return certificateListArray;
    }

    public BasicOCSPResponse[] getOcspVals() {
        if (null == this.b) {
            return new BasicOCSPResponse[0];
        }
        BasicOCSPResponse[] basicOCSPResponseArray = new BasicOCSPResponse[this.b.size()];
        for (int i2 = 0; i2 < basicOCSPResponseArray.length; ++i2) {
            basicOCSPResponseArray[i2] = BasicOCSPResponse.getInstance(this.b.getObjectAt(i2));
        }
        return basicOCSPResponseArray;
    }

    public OtherRevVals getOtherRevVals() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (null != this.a) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.a));
        }
        if (null != this.b) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.b));
        }
        if (null != this.c) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, this.c.toASN1Primitive()));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

