/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.tsp;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.cad.internal.bouncycastle.asn1.cms.Attribute;
import com.aspose.cad.internal.bouncycastle.asn1.cms.AttributeTable;
import com.aspose.cad.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.cad.internal.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.aspose.cad.internal.bouncycastle.asn1.ess.ESSCertID;
import com.aspose.cad.internal.bouncycastle.asn1.ess.ESSCertIDv2;
import com.aspose.cad.internal.bouncycastle.asn1.ess.SigningCertificate;
import com.aspose.cad.internal.bouncycastle.asn1.ess.SigningCertificateV2;
import com.aspose.cad.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.tsp.TSTInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.cad.internal.bouncycastle.asn1.x509.IssuerSerial;
import com.aspose.cad.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.cad.internal.bouncycastle.cms.CMSException;
import com.aspose.cad.internal.bouncycastle.cms.CMSSignedData;
import com.aspose.cad.internal.bouncycastle.cms.CMSTypedData;
import com.aspose.cad.internal.bouncycastle.cms.SignerId;
import com.aspose.cad.internal.bouncycastle.cms.SignerInformation;
import com.aspose.cad.internal.bouncycastle.cms.SignerInformationVerifier;
import com.aspose.cad.internal.bouncycastle.operator.DigestCalculator;
import com.aspose.cad.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.cad.internal.bouncycastle.tsp.TSPException;
import com.aspose.cad.internal.bouncycastle.tsp.TSPUtil;
import com.aspose.cad.internal.bouncycastle.tsp.TSPValidationException;
import com.aspose.cad.internal.bouncycastle.tsp.TimeStampTokenInfo;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import com.aspose.cad.internal.bouncycastle.util.Store;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;

public class TimeStampToken {
    CMSSignedData tsToken;
    SignerInformation tsaSignerInfo;
    Date genTime;
    TimeStampTokenInfo tstInfo;
    a certID;

    public TimeStampToken(ContentInfo contentInfo) throws TSPException, IOException {
        this(TimeStampToken.a(contentInfo));
    }

    private static CMSSignedData a(ContentInfo contentInfo) throws TSPException {
        try {
            return new CMSSignedData(contentInfo);
        }
        catch (CMSException cMSException) {
            throw new TSPException("TSP parsing error: " + cMSException.getMessage(), cMSException.getCause());
        }
    }

    public TimeStampToken(CMSSignedData cMSSignedData) throws TSPException, IOException {
        this.tsToken = cMSSignedData;
        if (!this.tsToken.getSignedContentTypeOID().equals(PKCSObjectIdentifiers.id_ct_TSTInfo.getId())) {
            throw new TSPValidationException("ContentInfo object not for a time stamp.");
        }
        Collection<SignerInformation> collection = this.tsToken.getSignerInfos().getSigners();
        if (collection.size() != 1) {
            throw new IllegalArgumentException("Time-stamp token signed by " + collection.size() + " signers, but it must contain just the TSA signature.");
        }
        this.tsaSignerInfo = collection.iterator().next();
        try {
            CMSTypedData cMSTypedData = this.tsToken.getSignedContent();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cMSTypedData.write(byteArrayOutputStream);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            this.tstInfo = new TimeStampTokenInfo(TSTInfo.getInstance(aSN1InputStream.readObject()));
            Attribute attribute = this.tsaSignerInfo.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificate);
            if (attribute != null) {
                SigningCertificate signingCertificate = SigningCertificate.getInstance(attribute.getAttrValues().getObjectAt(0));
                this.certID = new a(ESSCertID.getInstance(signingCertificate.getCerts()[0]));
            } else {
                attribute = this.tsaSignerInfo.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
                if (attribute == null) {
                    throw new TSPValidationException("no signing certificate attribute found, time stamp invalid.");
                }
                SigningCertificateV2 signingCertificateV2 = SigningCertificateV2.getInstance(attribute.getAttrValues().getObjectAt(0));
                this.certID = new a(ESSCertIDv2.getInstance(signingCertificateV2.getCerts()[0]));
            }
        }
        catch (CMSException cMSException) {
            throw new TSPException(cMSException.getMessage(), cMSException.getUnderlyingException());
        }
    }

    public TimeStampTokenInfo getTimeStampInfo() {
        return this.tstInfo;
    }

    public SignerId getSID() {
        return this.tsaSignerInfo.getSID();
    }

    public AttributeTable getSignedAttributes() {
        return this.tsaSignerInfo.getSignedAttributes();
    }

    public AttributeTable getUnsignedAttributes() {
        return this.tsaSignerInfo.getUnsignedAttributes();
    }

    public Store getCertificates() {
        return this.tsToken.getCertificates();
    }

    public Store getCRLs() {
        return this.tsToken.getCRLs();
    }

    public Store getAttributeCertificates() {
        return this.tsToken.getAttributeCertificates();
    }

    public void validate(SignerInformationVerifier signerInformationVerifier) throws TSPException, TSPValidationException {
        if (!signerInformationVerifier.hasAssociatedCertificate()) {
            throw new IllegalArgumentException("verifier provider needs an associated certificate");
        }
        try {
            X509CertificateHolder x509CertificateHolder = signerInformationVerifier.getAssociatedCertificate();
            DigestCalculator digestCalculator = signerInformationVerifier.getDigestCalculator(this.certID.b());
            OutputStream outputStream = digestCalculator.getOutputStream();
            outputStream.write(x509CertificateHolder.getEncoded());
            outputStream.close();
            if (!Arrays.constantTimeAreEqual(this.certID.c(), digestCalculator.getDigest())) {
                throw new TSPValidationException("certificate hash does not match certID hash.");
            }
            if (this.certID.d() != null) {
                IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509CertificateHolder.toASN1Structure());
                if (!this.certID.d().getSerial().equals(issuerAndSerialNumber.getSerialNumber())) {
                    throw new TSPValidationException("certificate serial number does not match certID for signature.");
                }
                GeneralName[] generalNameArray = this.certID.d().getIssuer().getNames();
                boolean bl2 = false;
                for (int i2 = 0; i2 != generalNameArray.length; ++i2) {
                    if (generalNameArray[i2].getTagNo() != 4 || !X500Name.getInstance(generalNameArray[i2].getName()).equals(X500Name.getInstance(issuerAndSerialNumber.getName()))) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    throw new TSPValidationException("certificate name does not match certID for signature. ");
                }
            }
            TSPUtil.validateCertificate(x509CertificateHolder);
            if (!x509CertificateHolder.isValidOn(this.tstInfo.getGenTime())) {
                throw new TSPValidationException("certificate not valid when time stamp created.");
            }
            if (!this.tsaSignerInfo.verify(signerInformationVerifier)) {
                throw new TSPValidationException("signature not created by certificate.");
            }
        }
        catch (CMSException cMSException) {
            if (cMSException.getUnderlyingException() != null) {
                throw new TSPException(cMSException.getMessage(), cMSException.getUnderlyingException());
            }
            throw new TSPException("CMS exception: " + cMSException, cMSException);
        }
        catch (IOException iOException) {
            throw new TSPException("problem processing certificate: " + iOException, iOException);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new TSPException("unable to create digest: " + operatorCreationException.getMessage(), operatorCreationException);
        }
    }

    public boolean isSignatureValid(SignerInformationVerifier signerInformationVerifier) throws TSPException {
        try {
            return this.tsaSignerInfo.verify(signerInformationVerifier);
        }
        catch (CMSException cMSException) {
            if (cMSException.getUnderlyingException() != null) {
                throw new TSPException(cMSException.getMessage(), cMSException.getUnderlyingException());
            }
            throw new TSPException("CMS exception: " + cMSException, cMSException);
        }
    }

    public CMSSignedData toCMSSignedData() {
        return this.tsToken;
    }

    public byte[] getEncoded() throws IOException {
        return this.tsToken.getEncoded();
    }

    private class a {
        private ESSCertID b;
        private ESSCertIDv2 c;

        a(ESSCertID eSSCertID) {
            this.b = eSSCertID;
            this.c = null;
        }

        a(ESSCertIDv2 eSSCertIDv2) {
            this.c = eSSCertIDv2;
            this.b = null;
        }

        public String a() {
            if (this.b != null) {
                return "SHA-1";
            }
            if (NISTObjectIdentifiers.id_sha256.equals(this.c.getHashAlgorithm().getAlgorithm())) {
                return "SHA-256";
            }
            return this.c.getHashAlgorithm().getAlgorithm().getId();
        }

        public AlgorithmIdentifier b() {
            if (this.b != null) {
                return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
            }
            return this.c.getHashAlgorithm();
        }

        public byte[] c() {
            if (this.b != null) {
                return this.b.getCertHash();
            }
            return this.c.getCertHash();
        }

        public IssuerSerial d() {
            if (this.b != null) {
                return this.b.getIssuerSerial();
            }
            return this.c.getIssuerSerial();
        }
    }
}

