/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.est.jcajce;

import com.aspose.cad.internal.bouncycastle.asn1.x509.ExtendedKeyUsage;
import com.aspose.cad.internal.bouncycastle.asn1.x509.KeyPurposeId;
import com.aspose.cad.internal.bouncycastle.asn1.x509.KeyUsage;
import com.aspose.cad.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.cad.internal.bouncycastle.est.jcajce.d;
import com.aspose.cad.internal.bouncycastle.est.jcajce.e;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509TrustManager;

public class JcaJceUtils {
    public static X509TrustManager getTrustAllTrustManager() {
        return new d();
    }

    public static X509TrustManager[] getCertPathTrustManager(Set<TrustAnchor> set, CRL[] cRLArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[set.size()];
        int n2 = 0;
        for (TrustAnchor trustAnchor : set) {
            x509CertificateArray[n2++] = trustAnchor.getTrustedCert();
        }
        return new X509TrustManager[]{new e(set, cRLArray, x509CertificateArray)};
    }

    public static void validateServerCertUsage(X509Certificate x509Certificate) throws CertificateException {
        try {
            ExtendedKeyUsage extendedKeyUsage;
            X509CertificateHolder x509CertificateHolder = new X509CertificateHolder(x509Certificate.getEncoded());
            KeyUsage keyUsage = KeyUsage.fromExtensions(x509CertificateHolder.getExtensions());
            if (keyUsage != null) {
                if (keyUsage.hasUsages(4)) {
                    throw new CertificateException("Key usage must not contain keyCertSign");
                }
                if (!keyUsage.hasUsages(128) && !keyUsage.hasUsages(32)) {
                    throw new CertificateException("Key usage must be none, digitalSignature or keyEncipherment");
                }
            }
            if (!((extendedKeyUsage = ExtendedKeyUsage.fromExtensions(x509CertificateHolder.getExtensions())) == null || extendedKeyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_serverAuth) || extendedKeyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_msSGC) || extendedKeyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_nsSGC))) {
                throw new CertificateException("Certificate extended key usage must include serverAuth, msSGC or nsSGC");
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Exception exception) {
            throw new CertificateException(exception.getMessage(), exception);
        }
    }

    public static KeyManagerFactory createKeyManagerFactory(String string, String string2, KeyStore keyStore, char[] cArray) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException {
        KeyManagerFactory keyManagerFactory = null;
        keyManagerFactory = string == null && string2 == null ? KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()) : (string2 == null ? KeyManagerFactory.getInstance(string) : KeyManagerFactory.getInstance(string, string2));
        keyManagerFactory.init(keyStore, cArray);
        return keyManagerFactory;
    }
}

