/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.digests;

import com.aspose.cad.internal.bouncycastle.crypto.ExtendedDigest;
import com.aspose.cad.internal.bouncycastle.util.Memoable;
import com.aspose.cad.internal.bouncycastle.util.Pack;

public abstract class GeneralDigest
implements ExtendedDigest,
Memoable {
    private static final int a = 64;
    private final byte[] b = new byte[4];
    private int c;
    private long d;

    protected GeneralDigest() {
        this.c = 0;
    }

    protected GeneralDigest(GeneralDigest generalDigest) {
        this.copyIn(generalDigest);
    }

    protected GeneralDigest(byte[] byArray) {
        System.arraycopy(byArray, 0, this.b, 0, this.b.length);
        this.c = Pack.bigEndianToInt(byArray, 4);
        this.d = Pack.bigEndianToLong(byArray, 8);
    }

    protected void copyIn(GeneralDigest generalDigest) {
        System.arraycopy(generalDigest.b, 0, this.b, 0, generalDigest.b.length);
        this.c = generalDigest.c;
        this.d = generalDigest.d;
    }

    @Override
    public void update(byte by2) {
        this.b[this.c++] = by2;
        if (this.c == this.b.length) {
            this.processWord(this.b, 0);
            this.c = 0;
        }
        ++this.d;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        n3 = Math.max(0, n3);
        int n4 = 0;
        if (this.c != 0) {
            while (n4 < n3) {
                this.b[this.c++] = byArray[n2 + n4++];
                if (this.c != 4) continue;
                this.processWord(this.b, 0);
                this.c = 0;
                break;
            }
        }
        int n5 = (n3 - n4 & 0xFFFFFFFC) + n4;
        while (n4 < n5) {
            this.processWord(byArray, n2 + n4);
            n4 += 4;
        }
        while (n4 < n3) {
            this.b[this.c++] = byArray[n2 + n4++];
        }
        this.d += (long)n3;
    }

    public void finish() {
        long l2 = this.d << 3;
        this.update((byte)-128);
        while (this.c != 0) {
            this.update((byte)0);
        }
        this.processLength(l2);
        this.processBlock();
    }

    @Override
    public void reset() {
        this.d = 0L;
        this.c = 0;
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            this.b[i2] = 0;
        }
    }

    protected void populateState(byte[] byArray) {
        System.arraycopy(this.b, 0, byArray, 0, this.c);
        Pack.intToBigEndian(this.c, byArray, 4);
        Pack.longToBigEndian(this.d, byArray, 8);
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    protected abstract void processWord(byte[] var1, int var2);

    protected abstract void processLength(long var1);

    protected abstract void processBlock();
}

