/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert.crmf;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Null;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.DERNull;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import com.aspose.cad.internal.bouncycastle.asn1.crmf.CertReqMsg;
import com.aspose.cad.internal.bouncycastle.asn1.crmf.CertRequest;
import com.aspose.cad.internal.bouncycastle.asn1.crmf.CertTemplate;
import com.aspose.cad.internal.bouncycastle.asn1.crmf.CertTemplateBuilder;
import com.aspose.cad.internal.bouncycastle.asn1.crmf.OptionalValidity;
import com.aspose.cad.internal.bouncycastle.asn1.crmf.POPOPrivKey;
import com.aspose.cad.internal.bouncycastle.asn1.crmf.ProofOfPossession;
import com.aspose.cad.internal.bouncycastle.asn1.crmf.SubsequentMessage;
import com.aspose.cad.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.cad.internal.bouncycastle.asn1.x509.ExtensionsGenerator;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Time;
import com.aspose.cad.internal.bouncycastle.cert.CertIOException;
import com.aspose.cad.internal.bouncycastle.cert.crmf.CRMFException;
import com.aspose.cad.internal.bouncycastle.cert.crmf.CertificateRequestMessage;
import com.aspose.cad.internal.bouncycastle.cert.crmf.Control;
import com.aspose.cad.internal.bouncycastle.cert.crmf.PKMACBuilder;
import com.aspose.cad.internal.bouncycastle.cert.crmf.ProofOfPossessionSigningKeyBuilder;
import com.aspose.cad.internal.bouncycastle.cert.crmf.a;
import com.aspose.cad.internal.bouncycastle.cert.crmf.c;
import com.aspose.cad.internal.bouncycastle.operator.ContentSigner;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CertificateRequestMessageBuilder {
    private final BigInteger a;
    private ExtensionsGenerator b;
    private CertTemplateBuilder c;
    private List d;
    private ContentSigner e;
    private PKMACBuilder f;
    private char[] g;
    private GeneralName h;
    private POPOPrivKey i;
    private ASN1Null j;

    public CertificateRequestMessageBuilder(BigInteger bigInteger) {
        this.a = bigInteger;
        this.b = new ExtensionsGenerator();
        this.c = new CertTemplateBuilder();
        this.d = new ArrayList();
    }

    public CertificateRequestMessageBuilder setPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        if (subjectPublicKeyInfo != null) {
            this.c.setPublicKey(subjectPublicKeyInfo);
        }
        return this;
    }

    public CertificateRequestMessageBuilder setIssuer(X500Name x500Name) {
        if (x500Name != null) {
            this.c.setIssuer(x500Name);
        }
        return this;
    }

    public CertificateRequestMessageBuilder setSubject(X500Name x500Name) {
        if (x500Name != null) {
            this.c.setSubject(x500Name);
        }
        return this;
    }

    public CertificateRequestMessageBuilder setSerialNumber(BigInteger bigInteger) {
        if (bigInteger != null) {
            this.c.setSerialNumber(new ASN1Integer(bigInteger));
        }
        return this;
    }

    public CertificateRequestMessageBuilder setValidity(Date date, Date date2) {
        this.c.setValidity(new OptionalValidity(this.a(date), this.a(date2)));
        return this;
    }

    private Time a(Date date) {
        if (date != null) {
            return new Time(date);
        }
        return null;
    }

    public CertificateRequestMessageBuilder addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, ASN1Encodable aSN1Encodable) throws CertIOException {
        com.aspose.cad.internal.bouncycastle.cert.crmf.a.a(this.b, aSN1ObjectIdentifier, bl2, aSN1Encodable);
        return this;
    }

    public CertificateRequestMessageBuilder addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, byte[] byArray) {
        this.b.addExtension(aSN1ObjectIdentifier, bl2, byArray);
        return this;
    }

    public CertificateRequestMessageBuilder addControl(Control control) {
        this.d.add(control);
        return this;
    }

    public CertificateRequestMessageBuilder setProofOfPossessionSigningKeySigner(ContentSigner contentSigner) {
        if (this.i != null || this.j != null) {
            throw new IllegalStateException("only one proof of possession allowed");
        }
        this.e = contentSigner;
        return this;
    }

    public CertificateRequestMessageBuilder setProofOfPossessionSubsequentMessage(SubsequentMessage subsequentMessage) {
        if (this.e != null || this.j != null) {
            throw new IllegalStateException("only one proof of possession allowed");
        }
        this.i = new POPOPrivKey(subsequentMessage);
        return this;
    }

    public CertificateRequestMessageBuilder setProofOfPossessionRaVerified() {
        if (this.e != null || this.i != null) {
            throw new IllegalStateException("only one proof of possession allowed");
        }
        this.j = DERNull.INSTANCE;
        return this;
    }

    public CertificateRequestMessageBuilder setAuthInfoPKMAC(PKMACBuilder pKMACBuilder, char[] cArray) {
        this.f = pKMACBuilder;
        this.g = cArray;
        return this;
    }

    public CertificateRequestMessageBuilder setAuthInfoSender(X500Name x500Name) {
        return this.setAuthInfoSender(new GeneralName(x500Name));
    }

    public CertificateRequestMessageBuilder setAuthInfoSender(GeneralName generalName) {
        this.h = generalName;
        return this;
    }

    public CertificateRequestMessage build() throws CRMFException {
        Object object;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        if (!this.b.isEmpty()) {
            this.c.setExtensions(this.b.generate());
        }
        aSN1EncodableVector.add(this.c.build());
        if (!this.d.isEmpty()) {
            object = new ASN1EncodableVector();
            for (Object object2 : this.d) {
                ((ASN1EncodableVector)object).add(new AttributeTypeAndValue(object2.getType(), object2.getValue()));
            }
            aSN1EncodableVector.add(new DERSequence((ASN1EncodableVector)object));
        }
        object = CertRequest.getInstance(new DERSequence(aSN1EncodableVector));
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)object);
        if (this.e != null) {
            Object object2;
            CertTemplate certTemplate = ((CertRequest)object).getCertTemplate();
            if (certTemplate.getSubject() == null || certTemplate.getPublicKey() == null) {
                object2 = ((CertRequest)object).getCertTemplate().getPublicKey();
                ProofOfPossessionSigningKeyBuilder proofOfPossessionSigningKeyBuilder = new ProofOfPossessionSigningKeyBuilder((SubjectPublicKeyInfo)object2);
                if (this.h != null) {
                    proofOfPossessionSigningKeyBuilder.setSender(this.h);
                } else {
                    c c2 = new c(this.f);
                    proofOfPossessionSigningKeyBuilder.setPublicKeyMac(c2, this.g);
                }
                aSN1EncodableVector.add(new ProofOfPossession(proofOfPossessionSigningKeyBuilder.build(this.e)));
            } else {
                object2 = new ProofOfPossessionSigningKeyBuilder((CertRequest)object);
                aSN1EncodableVector.add(new ProofOfPossession(((ProofOfPossessionSigningKeyBuilder)object2).build(this.e)));
            }
        } else if (this.i != null) {
            aSN1EncodableVector.add(new ProofOfPossession(2, this.i));
        } else if (this.j != null) {
            aSN1EncodableVector.add(new ProofOfPossession());
        }
        return new CertificateRequestMessage(CertReqMsg.getInstance(new DERSequence(aSN1EncodableVector)));
    }
}

