/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.ec;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.ec.ECDecryptor;
import com.aspose.cad.internal.bouncycastle.crypto.ec.ECPair;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.cad.internal.bouncycastle.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters a;

    @Override
    public void init(CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
        }
        this.a = (ECPrivateKeyParameters)cipherParameters;
    }

    @Override
    public ECPoint decrypt(ECPair eCPair) {
        if (this.a == null) {
            throw new IllegalStateException("ECElGamalDecryptor not initialised");
        }
        ECPoint eCPoint = eCPair.getX().multiply(this.a.getD());
        return eCPair.getY().subtract(eCPoint).normalize();
    }
}

