/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.cms;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.BERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.cad.internal.bouncycastle.asn1.cms.OriginatorInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.util.Enumeration;

public class AuthenticatedData
extends ASN1Object {
    private ASN1Integer a;
    private OriginatorInfo b;
    private ASN1Set c;
    private AlgorithmIdentifier d;
    private AlgorithmIdentifier e;
    private ContentInfo f;
    private ASN1Set g;
    private ASN1OctetString h;
    private ASN1Set i;

    public AuthenticatedData(OriginatorInfo originatorInfo, ASN1Set aSN1Set, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, ContentInfo contentInfo, ASN1Set aSN1Set2, ASN1OctetString aSN1OctetString, ASN1Set aSN1Set3) {
        if (!(algorithmIdentifier2 == null && aSN1Set2 == null || algorithmIdentifier2 != null && aSN1Set2 != null)) {
            throw new IllegalArgumentException("digestAlgorithm and authAttrs must be set together");
        }
        this.a = new ASN1Integer(AuthenticatedData.calculateVersion(originatorInfo));
        this.b = originatorInfo;
        this.d = algorithmIdentifier;
        this.e = algorithmIdentifier2;
        this.c = aSN1Set;
        this.f = contentInfo;
        this.g = aSN1Set2;
        this.h = aSN1OctetString;
        this.i = aSN1Set3;
    }

    private AuthenticatedData(ASN1Sequence aSN1Sequence) {
        int n2 = 0;
        this.a = (ASN1Integer)aSN1Sequence.getObjectAt(n2++);
        ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(n2++);
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            this.b = OriginatorInfo.getInstance((ASN1TaggedObject)aSN1Encodable, false);
            aSN1Encodable = aSN1Sequence.getObjectAt(n2++);
        }
        this.c = ASN1Set.getInstance(aSN1Encodable);
        this.d = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n2++));
        if ((aSN1Encodable = aSN1Sequence.getObjectAt(n2++)) instanceof ASN1TaggedObject) {
            this.e = AlgorithmIdentifier.getInstance((ASN1TaggedObject)aSN1Encodable, false);
            aSN1Encodable = aSN1Sequence.getObjectAt(n2++);
        }
        this.f = ContentInfo.getInstance(aSN1Encodable);
        if ((aSN1Encodable = aSN1Sequence.getObjectAt(n2++)) instanceof ASN1TaggedObject) {
            this.g = ASN1Set.getInstance((ASN1TaggedObject)aSN1Encodable, false);
            aSN1Encodable = aSN1Sequence.getObjectAt(n2++);
        }
        this.h = ASN1OctetString.getInstance(aSN1Encodable);
        if (aSN1Sequence.size() > n2) {
            this.i = ASN1Set.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n2), false);
        }
    }

    public static AuthenticatedData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return AuthenticatedData.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static AuthenticatedData getInstance(Object object) {
        if (object instanceof AuthenticatedData) {
            return (AuthenticatedData)object;
        }
        if (object != null) {
            return new AuthenticatedData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.b;
    }

    public ASN1Set getRecipientInfos() {
        return this.c;
    }

    public AlgorithmIdentifier getMacAlgorithm() {
        return this.d;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.e;
    }

    public ContentInfo getEncapsulatedContentInfo() {
        return this.f;
    }

    public ASN1Set getAuthAttrs() {
        return this.g;
    }

    public ASN1OctetString getMac() {
        return this.h;
    }

    public ASN1Set getUnauthAttrs() {
        return this.i;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.b));
        }
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        if (this.e != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.e));
        }
        aSN1EncodableVector.add(this.f);
        if (this.g != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, this.g));
        }
        aSN1EncodableVector.add(this.h);
        if (this.i != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 3, this.i));
        }
        return new BERSequence(aSN1EncodableVector);
    }

    public static int calculateVersion(OriginatorInfo originatorInfo) {
        ASN1TaggedObject aSN1TaggedObject;
        Object e2;
        if (originatorInfo == null) {
            return 0;
        }
        int n2 = 0;
        Enumeration enumeration = originatorInfo.getCertificates().getObjects();
        while (enumeration.hasMoreElements()) {
            e2 = enumeration.nextElement();
            if (!(e2 instanceof ASN1TaggedObject)) continue;
            aSN1TaggedObject = (ASN1TaggedObject)e2;
            if (aSN1TaggedObject.getTagNo() == 2) {
                n2 = 1;
                continue;
            }
            if (aSN1TaggedObject.getTagNo() != 3) continue;
            n2 = 3;
            break;
        }
        if (originatorInfo.getCRLs() != null) {
            enumeration = originatorInfo.getCRLs().getObjects();
            while (enumeration.hasMoreElements()) {
                e2 = enumeration.nextElement();
                if (!(e2 instanceof ASN1TaggedObject) || (aSN1TaggedObject = (ASN1TaggedObject)e2).getTagNo() != 1) continue;
                n2 = 3;
                break;
            }
        }
        return n2;
    }
}

