/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.tsp;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.tsp.TimeStampReq;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.cad.internal.bouncycastle.tsp.TSPException;
import com.aspose.cad.internal.bouncycastle.tsp.TSPUtil;
import com.aspose.cad.internal.bouncycastle.tsp.TSPValidationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TimeStampRequest {
    private static Set a = Collections.unmodifiableSet(new HashSet());
    private TimeStampReq b;
    private Extensions c;

    public TimeStampRequest(TimeStampReq timeStampReq) {
        this.b = timeStampReq;
        this.c = timeStampReq.getExtensions();
    }

    public TimeStampRequest(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public TimeStampRequest(InputStream inputStream) throws IOException {
        this(TimeStampRequest.a(inputStream));
    }

    private static TimeStampReq a(InputStream inputStream) throws IOException {
        try {
            return TimeStampReq.getInstance(new ASN1InputStream(inputStream).readObject());
        }
        catch (ClassCastException classCastException) {
            throw new IOException("malformed request: " + classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("malformed request: " + illegalArgumentException);
        }
    }

    public int getVersion() {
        return this.b.getVersion().getValue().intValue();
    }

    public ASN1ObjectIdentifier getMessageImprintAlgOID() {
        return this.b.getMessageImprint().getHashAlgorithm().getAlgorithm();
    }

    public byte[] getMessageImprintDigest() {
        return this.b.getMessageImprint().getHashedMessage();
    }

    public ASN1ObjectIdentifier getReqPolicy() {
        if (this.b.getReqPolicy() != null) {
            return this.b.getReqPolicy();
        }
        return null;
    }

    public BigInteger getNonce() {
        if (this.b.getNonce() != null) {
            return this.b.getNonce().getValue();
        }
        return null;
    }

    public boolean getCertReq() {
        if (this.b.getCertReq() != null) {
            return this.b.getCertReq().isTrue();
        }
        return false;
    }

    public void validate(Set set, Set set2, Set set3) throws TSPException {
        int n2;
        set = this.a(set);
        set2 = this.a(set2);
        set3 = this.a(set3);
        if (!set.contains(this.getMessageImprintAlgOID())) {
            throw new TSPValidationException("request contains unknown algorithm", 128);
        }
        if (set2 != null && this.getReqPolicy() != null && !set2.contains(this.getReqPolicy())) {
            throw new TSPValidationException("request contains unknown policy", 256);
        }
        if (this.getExtensions() != null && set3 != null) {
            Enumeration enumeration = this.getExtensions().oids();
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                if (set3.contains(aSN1ObjectIdentifier)) continue;
                throw new TSPValidationException("request contains unknown extension", 0x800000);
            }
        }
        if ((n2 = TSPUtil.getDigestLength(this.getMessageImprintAlgOID().getId())) != this.getMessageImprintDigest().length) {
            throw new TSPValidationException("imprint digest the wrong length", 4);
        }
    }

    public byte[] getEncoded() throws IOException {
        return this.b.getEncoded();
    }

    Extensions getExtensions() {
        return this.c;
    }

    public boolean hasExtensions() {
        return this.c != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.c != null) {
            return this.c.getExtension(aSN1ObjectIdentifier);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return TSPUtil.getExtensionOIDs(this.c);
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.c == null) {
            return a;
        }
        return Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(this.c.getNonCriticalExtensionOIDs())));
    }

    public Set getCriticalExtensionOIDs() {
        if (this.c == null) {
            return a;
        }
        return Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(this.c.getCriticalExtensionOIDs())));
    }

    private Set a(Set set) {
        if (set == null) {
            return set;
        }
        HashSet<ASN1ObjectIdentifier> hashSet = new HashSet<ASN1ObjectIdentifier>(set.size());
        for (Object e2 : set) {
            if (e2 instanceof String) {
                hashSet.add(new ASN1ObjectIdentifier((String)e2));
                continue;
            }
            hashSet.add((ASN1ObjectIdentifier)e2);
        }
        return hashSet;
    }
}

