/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.modes;

import com.aspose.cad.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.cad.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.modes.AEADBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.modes.gcm.BasicGCMExponentiator;
import com.aspose.cad.internal.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import com.aspose.cad.internal.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.aspose.cad.internal.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.aspose.cad.internal.bouncycastle.crypto.modes.gcm.Tables4kGCMMultiplier;
import com.aspose.cad.internal.bouncycastle.crypto.params.AEADParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import com.aspose.cad.internal.bouncycastle.util.Pack;

public class GCMBlockCipher
implements AEADBlockCipher {
    private static final int a = 16;
    private BlockCipher b;
    private GCMMultiplier c;
    private GCMExponentiator d;
    private boolean e;
    private boolean f;
    private int g;
    private byte[] h;
    private byte[] i;
    private byte[] j;
    private byte[] k;
    private byte[] l;
    private byte[] m;
    private byte[] n;
    private byte[] o;
    private byte[] p;
    private byte[] q;
    private byte[] r;
    private int s;
    private int t;
    private long u;
    private byte[] v;
    private int w;
    private long x;
    private long y;

    public GCMBlockCipher(BlockCipher blockCipher) {
        this(blockCipher, null);
    }

    public GCMBlockCipher(BlockCipher blockCipher, GCMMultiplier gCMMultiplier) {
        if (blockCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
        if (gCMMultiplier == null) {
            gCMMultiplier = new Tables4kGCMMultiplier();
        }
        this.b = blockCipher;
        this.c = gCMMultiplier;
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.b;
    }

    @Override
    public String getAlgorithmName() {
        return this.b.getAlgorithmName() + "/GCM";
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        KeyParameter keyParameter;
        CipherParameters cipherParameters2;
        this.e = bl2;
        this.n = null;
        this.f = true;
        byte[] byArray = null;
        if (cipherParameters instanceof AEADParameters) {
            cipherParameters2 = (AEADParameters)cipherParameters;
            byArray = ((AEADParameters)cipherParameters2).getNonce();
            this.j = ((AEADParameters)cipherParameters2).getAssociatedText();
            int n2 = ((AEADParameters)cipherParameters2).getMacSize();
            if (n2 < 32 || n2 > 128 || n2 % 8 != 0) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + n2);
            }
            this.g = n2 / 8;
            keyParameter = ((AEADParameters)cipherParameters2).getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            cipherParameters2 = (ParametersWithIV)cipherParameters;
            byArray = ((ParametersWithIV)cipherParameters2).getIV();
            this.j = null;
            this.g = 16;
            keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters2).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM");
        }
        int n3 = bl2 ? 16 : 16 + this.g;
        this.m = new byte[n3];
        if (byArray == null || byArray.length < 1) {
            throw new IllegalArgumentException("IV must be at least 1 byte");
        }
        if (bl2 && this.i != null && Arrays.areEqual(this.i, byArray)) {
            if (keyParameter == null) {
                throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
            }
            if (this.h != null && Arrays.areEqual(this.h, keyParameter.getKey())) {
                throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
            }
        }
        this.i = byArray;
        if (keyParameter != null) {
            this.h = keyParameter.getKey();
        }
        if (keyParameter != null) {
            this.b.init(true, keyParameter);
            this.k = new byte[16];
            this.b.processBlock(this.k, 0, this.k, 0);
            this.c.init(this.k);
            this.d = null;
        } else if (this.k == null) {
            throw new IllegalArgumentException("Key must be specified in initial init");
        }
        this.l = new byte[16];
        if (this.i.length == 12) {
            System.arraycopy(this.i, 0, this.l, 0, this.i.length);
            this.l[15] = 1;
        } else {
            this.a(this.l, this.i, this.i.length);
            byte[] byArray2 = new byte[16];
            Pack.longToBigEndian((long)this.i.length * 8L, byArray2, 8);
            this.a(this.l, byArray2);
        }
        this.o = new byte[16];
        this.p = new byte[16];
        this.q = new byte[16];
        this.v = new byte[16];
        this.w = 0;
        this.x = 0L;
        this.y = 0L;
        this.r = Arrays.clone(this.l);
        this.s = -2;
        this.t = 0;
        this.u = 0L;
        if (this.j != null) {
            this.processAADBytes(this.j, 0, this.j.length);
        }
    }

    @Override
    public byte[] getMac() {
        if (this.n == null) {
            return new byte[this.g];
        }
        return Arrays.clone(this.n);
    }

    @Override
    public int getOutputSize(int n2) {
        int n3 = n2 + this.t;
        if (this.e) {
            return n3 + this.g;
        }
        return n3 < this.g ? 0 : n3 - this.g;
    }

    @Override
    public int getUpdateOutputSize(int n2) {
        int n3 = n2 + this.t;
        if (!this.e) {
            if (n3 < this.g) {
                return 0;
            }
            n3 -= this.g;
        }
        return n3 - n3 % 16;
    }

    @Override
    public void processAADByte(byte by2) {
        this.b();
        this.v[this.w] = by2;
        if (++this.w == 16) {
            this.a(this.p, this.v);
            this.w = 0;
            this.x += 16L;
        }
    }

    @Override
    public void processAADBytes(byte[] byArray, int n2, int n3) {
        this.b();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.v[this.w] = byArray[n2 + i2];
            if (++this.w != 16) continue;
            this.a(this.p, this.v);
            this.w = 0;
            this.x += 16L;
        }
    }

    private void a() {
        if (this.x > 0L) {
            System.arraycopy(this.p, 0, this.q, 0, 16);
            this.y = this.x;
        }
        if (this.w > 0) {
            this.a(this.q, this.v, 0, this.w);
            this.y += (long)this.w;
        }
        if (this.y > 0L) {
            System.arraycopy(this.q, 0, this.o, 0, 16);
        }
    }

    @Override
    public int processByte(byte by2, byte[] byArray, int n2) throws DataLengthException {
        this.b();
        this.m[this.t] = by2;
        if (++this.t == this.m.length) {
            this.a(this.m, 0, byArray, n2);
            if (this.e) {
                this.t = 0;
            } else {
                System.arraycopy(this.m, 16, this.m, 0, this.g);
                this.t = this.g;
            }
            return 16;
        }
        return 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException {
        this.b();
        if (byArray.length - n2 < n3) {
            throw new DataLengthException("Input buffer too short");
        }
        int n5 = 0;
        if (this.e) {
            if (this.t != 0) {
                while (n3 > 0) {
                    --n3;
                    this.m[this.t] = byArray[n2++];
                    if (++this.t != 16) continue;
                    this.a(this.m, 0, byArray2, n4);
                    this.t = 0;
                    n5 += 16;
                    break;
                }
            }
            while (n3 >= 16) {
                this.a(byArray, n2, byArray2, n4 + n5);
                n2 += 16;
                n3 -= 16;
                n5 += 16;
            }
            if (n3 > 0) {
                System.arraycopy(byArray, n2, this.m, 0, n3);
                this.t = n3;
            }
        } else {
            for (int i2 = 0; i2 < n3; ++i2) {
                this.m[this.t] = byArray[n2 + i2];
                if (++this.t != this.m.length) continue;
                this.a(this.m, 0, byArray2, n4 + n5);
                System.arraycopy(this.m, 16, this.m, 0, this.g);
                this.t = this.g;
                n5 += 16;
            }
        }
        return n5;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, InvalidCipherTextException {
        this.b();
        if (this.u == 0L) {
            this.a();
        }
        int n3 = this.t;
        if (this.e) {
            if (byArray.length - n2 < n3 + this.g) {
                throw new OutputLengthException("Output buffer too short");
            }
        } else {
            if (n3 < this.g) {
                throw new InvalidCipherTextException("data too short");
            }
            if (byArray.length - n2 < (n3 -= this.g)) {
                throw new OutputLengthException("Output buffer too short");
            }
        }
        if (n3 > 0) {
            this.a(this.m, 0, n3, byArray, n2);
        }
        this.x += (long)this.w;
        if (this.x > this.y) {
            if (this.w > 0) {
                this.a(this.p, this.v, 0, this.w);
            }
            if (this.y > 0L) {
                GCMUtil.xor(this.p, this.q);
            }
            long l2 = this.u * 8L + 127L >>> 7;
            byte[] byArray2 = new byte[16];
            if (this.d == null) {
                this.d = new BasicGCMExponentiator();
                this.d.init(this.k);
            }
            this.d.exponentiateX(l2, byArray2);
            GCMUtil.multiply(this.p, byArray2);
            GCMUtil.xor(this.o, this.p);
        }
        byte[] byArray3 = new byte[16];
        Pack.longToBigEndian(this.x * 8L, byArray3, 0);
        Pack.longToBigEndian(this.u * 8L, byArray3, 8);
        this.a(this.o, byArray3);
        byte[] byArray4 = new byte[16];
        this.b.processBlock(this.l, 0, byArray4, 0);
        GCMUtil.xor(byArray4, this.o);
        int n4 = n3;
        this.n = new byte[this.g];
        System.arraycopy(byArray4, 0, this.n, 0, this.g);
        if (this.e) {
            System.arraycopy(this.n, 0, byArray, n2 + this.t, this.g);
            n4 += this.g;
        } else {
            byte[] byArray5 = new byte[this.g];
            System.arraycopy(this.m, n3, byArray5, 0, this.g);
            if (!Arrays.constantTimeAreEqual(this.n, byArray5)) {
                throw new InvalidCipherTextException("mac check in GCM failed");
            }
        }
        this.a(false);
        return n4;
    }

    @Override
    public void reset() {
        this.a(true);
    }

    private void a(boolean bl2) {
        this.b.reset();
        this.o = new byte[16];
        this.p = new byte[16];
        this.q = new byte[16];
        this.v = new byte[16];
        this.w = 0;
        this.x = 0L;
        this.y = 0L;
        this.r = Arrays.clone(this.l);
        this.s = -2;
        this.t = 0;
        this.u = 0L;
        if (this.m != null) {
            Arrays.fill(this.m, (byte)0);
        }
        if (bl2) {
            this.n = null;
        }
        if (this.e) {
            this.f = false;
        } else if (this.j != null) {
            this.processAADBytes(this.j, 0, this.j.length);
        }
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (byArray2.length - n3 < 16) {
            throw new OutputLengthException("Output buffer too short");
        }
        if (this.u == 0L) {
            this.a();
        }
        byte[] byArray3 = new byte[16];
        this.a(byArray3);
        if (this.e) {
            GCMUtil.xor(byArray3, byArray, n2);
            this.a(this.o, byArray3);
            System.arraycopy(byArray3, 0, byArray2, n3, 16);
        } else {
            this.b(this.o, byArray, n2);
            GCMUtil.xor(byArray3, 0, byArray, n2, byArray2, n3);
        }
        this.u += 16L;
    }

    private void a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = new byte[16];
        this.a(byArray3);
        if (this.e) {
            GCMUtil.xor(byArray, n2, byArray3, 0, n3);
            this.a(this.o, byArray, n2, n3);
        } else {
            this.a(this.o, byArray, n2, n3);
            GCMUtil.xor(byArray, n2, byArray3, 0, n3);
        }
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        this.u += (long)n3;
    }

    private void a(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; i2 += 16) {
            int n3 = Math.min(n2 - i2, 16);
            this.a(byArray, byArray2, i2, n3);
        }
    }

    private void a(byte[] byArray, byte[] byArray2) {
        GCMUtil.xor(byArray, byArray2);
        this.c.multiplyH(byArray);
    }

    private void b(byte[] byArray, byte[] byArray2, int n2) {
        GCMUtil.xor(byArray, byArray2, n2);
        this.c.multiplyH(byArray);
    }

    private void a(byte[] byArray, byte[] byArray2, int n2, int n3) {
        GCMUtil.xor(byArray, byArray2, n2, n3);
        this.c.multiplyH(byArray);
    }

    private void a(byte[] byArray) {
        if (this.s == 0) {
            throw new IllegalStateException("Attempt to process too many blocks");
        }
        --this.s;
        int n2 = 1;
        this.r[15] = (byte)(n2 += this.r[15] & 0xFF);
        n2 >>>= 8;
        this.r[14] = (byte)(n2 += this.r[14] & 0xFF);
        n2 >>>= 8;
        this.r[13] = (byte)(n2 += this.r[13] & 0xFF);
        n2 >>>= 8;
        this.r[12] = (byte)(n2 += this.r[12] & 0xFF);
        this.b.processBlock(this.r, 0, byArray, 0);
    }

    private void b() {
        if (!this.f) {
            if (this.e) {
                throw new IllegalStateException("GCM cipher cannot be reused for encryption");
            }
            throw new IllegalStateException("GCM cipher needs to be initialised");
        }
    }
}

