/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.modes;

import com.aspose.cad.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.StreamBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.modes.a;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.cad.internal.bouncycastle.util.Arrays;

public class G3413CTRBlockCipher
extends StreamBlockCipher {
    private final int a;
    private byte[] b;
    private byte[] c;
    private byte[] d;
    private final int e;
    private final BlockCipher f;
    private int g = 0;
    private boolean h;

    public G3413CTRBlockCipher(BlockCipher blockCipher) {
        this(blockCipher, blockCipher.getBlockSize() * 8);
    }

    public G3413CTRBlockCipher(BlockCipher blockCipher, int n2) {
        super(blockCipher);
        if (n2 < 0 || n2 > blockCipher.getBlockSize() * 8) {
            throw new IllegalArgumentException("Parameter bitBlockSize must be in range 0 < bitBlockSize <= " + blockCipher.getBlockSize() * 8);
        }
        this.f = blockCipher;
        this.e = blockCipher.getBlockSize();
        this.a = n2 / 8;
        this.b = new byte[this.e];
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            this.a();
            this.c = Arrays.clone(parametersWithIV.getIV());
            if (this.c.length != this.e / 2) {
                throw new IllegalArgumentException("Parameter IV length must be == blockSize/2");
            }
            System.arraycopy(this.c, 0, this.b, 0, this.c.length);
            for (int i2 = this.c.length; i2 < this.e; ++i2) {
                this.b[i2] = 0;
            }
            if (parametersWithIV.getParameters() != null) {
                this.f.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.a();
            if (cipherParameters != null) {
                this.f.init(true, cipherParameters);
            }
        }
        this.h = true;
    }

    private void a() {
        this.c = new byte[this.e / 2];
        this.b = new byte[this.e];
        this.d = new byte[this.a];
    }

    @Override
    public String getAlgorithmName() {
        return this.f.getAlgorithmName() + "/GCTR";
    }

    @Override
    public int getBlockSize() {
        return this.a;
    }

    @Override
    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n2, this.a, byArray2, n3);
        return this.a;
    }

    @Override
    protected byte calculateByte(byte by2) {
        if (this.g == 0) {
            this.d = this.c();
        }
        byte by3 = (byte)(this.d[this.g] ^ by2);
        ++this.g;
        if (this.g == this.a) {
            this.g = 0;
            this.b();
        }
        return by3;
    }

    private void b() {
        int n2 = this.b.length - 1;
        this.b[n2] = (byte)(this.b[n2] + 1);
    }

    private byte[] c() {
        byte[] byArray = new byte[this.b.length];
        this.f.processBlock(this.b, 0, byArray, 0);
        return com.aspose.cad.internal.bouncycastle.crypto.modes.a.a(byArray, this.a);
    }

    @Override
    public void reset() {
        if (this.h) {
            System.arraycopy(this.c, 0, this.b, 0, this.c.length);
            for (int i2 = this.c.length; i2 < this.e; ++i2) {
                this.b[i2] = 0;
            }
            this.g = 0;
            this.f.reset();
        }
    }
}

