/*
 * Decompiled with CFR 0.152.
 */
package cpdetector.io;

import cpdetector.io.AbstractCodepageDetector;
import cpdetector.io.ICodepageDetector;
import cpdetector.io.UnknownCharset;
import cpdetector.io.UnsupportedCharset;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public final class CodepageDetectorProxy
extends AbstractCodepageDetector {
    private static CodepageDetectorProxy instance = null;
    private Set detectors = new LinkedHashSet();

    private CodepageDetectorProxy() {
    }

    public static CodepageDetectorProxy getInstance() {
        if (instance == null) {
            instance = new CodepageDetectorProxy();
        }
        return instance;
    }

    public boolean add(ICodepageDetector detector) {
        return this.detectors.add(detector);
    }

    public Charset detectCodepage(URL url) throws IOException {
        Charset ret = null;
        Iterator detectorIt = this.detectors.iterator();
        while (detectorIt.hasNext() && ((ret = ((ICodepageDetector)detectorIt.next()).detectCodepage(url)) == null || ret == UnknownCharset.getInstance() || ret instanceof UnsupportedCharset)) {
        }
        return ret;
    }

    public Charset detectCodepage(InputStream in, int length) throws IOException {
        in.mark(length);
        Charset ret = null;
        Iterator detectorIt = this.detectors.iterator();
        while (detectorIt.hasNext()) {
            ret = ((ICodepageDetector)detectorIt.next()).detectCodepage(in, length);
            in.reset();
            if (ret == null || ret == UnknownCharset.getInstance() || ret instanceof UnsupportedCharset) continue;
        }
        return ret;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        Iterator it = this.detectors.iterator();
        int i = 1;
        while (it.hasNext()) {
            ret.append(i);
            ret.append(") ");
            ret.append(it.next().getClass().getName());
            ret.append("\n");
            ++i;
        }
        return ret.toString();
    }
}

