/*
 * Decompiled with CFR 0.152.
 */
package cpdetector;

import cpdetector.io.ASCIIDetector;
import cpdetector.io.CodepageDetectorProxy;
import cpdetector.io.JChardetFacade;
import cpdetector.io.ParsingDetector;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;

public class CharsetPrinter {
    private final CodepageDetectorProxy detector = CodepageDetectorProxy.getInstance();

    public CharsetPrinter() {
        this.detector.add(new ParsingDetector(false));
        this.detector.add(JChardetFacade.getInstance());
        this.detector.add(ASCIIDetector.getInstance());
    }

    public String guessEncoding(File f) throws MalformedURLException, IOException {
        Charset charset = this.detector.detectCodepage(f.toURL());
        if (charset == null) {
            return null;
        }
        return charset.name();
    }

    public static void main(String[] args) {
        CharsetPrinter cp = new CharsetPrinter();
        if (args.length < 1) {
            System.err.println("Please provide one or more files to examine on the command line after the command.");
        }
        try {
            for (int walk = 0; walk < args.length; ++walk) {
                File f = new File(args[walk]);
                if (f.exists() && f.canRead() && f.isFile()) {
                    System.out.println(args[walk] + " appears to be " + cp.guessEncoding(f));
                    continue;
                }
                System.err.println(args[walk] + " is not a file, does not exists or is not readable at this time.");
                System.out.println(args[walk] + " appears to be UNKNOWN");
            }
        }
        catch (MalformedURLException e) {
            System.err.println("The filename makes no sense.");
        }
        catch (IOException e) {
            System.err.println("Problem reading from file");
            e.printStackTrace();
        }
    }
}

