/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert.path.validations;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Null;
import com.aspose.cad.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.cad.internal.bouncycastle.cert.CertException;
import com.aspose.cad.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.cad.internal.bouncycastle.cert.X509ContentVerifierProviderBuilder;
import com.aspose.cad.internal.bouncycastle.cert.path.CertPathValidation;
import com.aspose.cad.internal.bouncycastle.cert.path.CertPathValidationContext;
import com.aspose.cad.internal.bouncycastle.cert.path.CertPathValidationException;
import com.aspose.cad.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.cad.internal.bouncycastle.util.Memoable;
import java.io.IOException;

public class ParentCertIssuedValidation
implements CertPathValidation {
    private X509ContentVerifierProviderBuilder a;
    private X500Name b;
    private SubjectPublicKeyInfo c;
    private AlgorithmIdentifier d;

    public ParentCertIssuedValidation(X509ContentVerifierProviderBuilder x509ContentVerifierProviderBuilder) {
        this.a = x509ContentVerifierProviderBuilder;
    }

    @Override
    public void validate(CertPathValidationContext certPathValidationContext, X509CertificateHolder x509CertificateHolder) throws CertPathValidationException {
        if (this.b != null && !this.b.equals(x509CertificateHolder.getIssuer())) {
            throw new CertPathValidationException("Certificate issue does not match parent");
        }
        if (this.c != null) {
            try {
                SubjectPublicKeyInfo subjectPublicKeyInfo = this.c.getAlgorithm().equals(this.d) ? this.c : new SubjectPublicKeyInfo(this.d, this.c.parsePublicKey());
                if (!x509CertificateHolder.isSignatureValid(this.a.build(subjectPublicKeyInfo))) {
                    throw new CertPathValidationException("Certificate signature not for public key in parent");
                }
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CertPathValidationException("Unable to create verifier: " + operatorCreationException.getMessage(), operatorCreationException);
            }
            catch (CertException certException) {
                throw new CertPathValidationException("Unable to validate signature: " + certException.getMessage(), certException);
            }
            catch (IOException iOException) {
                throw new CertPathValidationException("Unable to build public key: " + iOException.getMessage(), iOException);
            }
        }
        this.b = x509CertificateHolder.getSubject();
        this.c = x509CertificateHolder.getSubjectPublicKeyInfo();
        if (this.d != null) {
            if (this.c.getAlgorithm().getAlgorithm().equals(this.d.getAlgorithm())) {
                if (!this.a(this.c.getAlgorithm().getParameters())) {
                    this.d = this.c.getAlgorithm();
                }
            } else {
                this.d = this.c.getAlgorithm();
            }
        } else {
            this.d = this.c.getAlgorithm();
        }
    }

    private boolean a(ASN1Encodable aSN1Encodable) {
        return aSN1Encodable == null || aSN1Encodable instanceof ASN1Null;
    }

    @Override
    public Memoable copy() {
        ParentCertIssuedValidation parentCertIssuedValidation = new ParentCertIssuedValidation(this.a);
        parentCertIssuedValidation.d = this.d;
        parentCertIssuedValidation.b = this.b;
        parentCertIssuedValidation.c = this.c;
        return parentCertIssuedValidation;
    }

    @Override
    public void reset(Memoable memoable) {
        ParentCertIssuedValidation parentCertIssuedValidation = (ParentCertIssuedValidation)memoable;
        this.a = parentCertIssuedValidation.a;
        this.d = parentCertIssuedValidation.d;
        this.b = parentCertIssuedValidation.b;
        this.c = parentCertIssuedValidation.c;
    }
}

