/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert.crmf;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.DERBitString;
import com.aspose.cad.internal.bouncycastle.asn1.crmf.EncryptedValue;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.cad.internal.bouncycastle.cert.crmf.CRMFException;
import com.aspose.cad.internal.bouncycastle.cert.crmf.EncryptedValuePadder;
import com.aspose.cad.internal.bouncycastle.operator.KeyWrapper;
import com.aspose.cad.internal.bouncycastle.operator.OperatorException;
import com.aspose.cad.internal.bouncycastle.operator.OutputEncryptor;
import com.aspose.cad.internal.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import com.aspose.cad.internal.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfoBuilder;
import com.aspose.cad.internal.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EncryptedValueBuilder {
    private KeyWrapper a;
    private OutputEncryptor b;
    private EncryptedValuePadder c;

    public EncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor) {
        this(keyWrapper, outputEncryptor, null);
    }

    public EncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor, EncryptedValuePadder encryptedValuePadder) {
        this.a = keyWrapper;
        this.b = outputEncryptor;
        this.c = encryptedValuePadder;
    }

    public EncryptedValue build(char[] cArray) throws CRMFException {
        return this.a(this.b(Strings.toUTF8ByteArray(cArray)));
    }

    public EncryptedValue build(X509CertificateHolder x509CertificateHolder) throws CRMFException {
        try {
            return this.a(this.b(x509CertificateHolder.getEncoded()));
        }
        catch (IOException iOException) {
            throw new CRMFException("cannot encode certificate: " + iOException.getMessage(), iOException);
        }
    }

    public EncryptedValue build(PrivateKeyInfo privateKeyInfo) throws CRMFException {
        PKCS8EncryptedPrivateKeyInfoBuilder pKCS8EncryptedPrivateKeyInfoBuilder = new PKCS8EncryptedPrivateKeyInfoBuilder(privateKeyInfo);
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        AlgorithmIdentifier algorithmIdentifier2 = this.b.getAlgorithmIdentifier();
        try {
            PKCS8EncryptedPrivateKeyInfo pKCS8EncryptedPrivateKeyInfo = pKCS8EncryptedPrivateKeyInfoBuilder.build(this.b);
            this.a.generateWrappedKey(this.b.getKey());
            DERBitString dERBitString = new DERBitString(this.a.generateWrappedKey(this.b.getKey()));
            AlgorithmIdentifier algorithmIdentifier3 = this.a.getAlgorithmIdentifier();
            ASN1OctetString aSN1OctetString = null;
            return new EncryptedValue(algorithmIdentifier, algorithmIdentifier2, dERBitString, algorithmIdentifier3, aSN1OctetString, new DERBitString(pKCS8EncryptedPrivateKeyInfo.getEncoded()));
        }
        catch (IOException iOException) {
            throw new CRMFException("cannot encode encrypted private key: " + iOException.getMessage(), iOException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new CRMFException("cannot encode key: " + illegalStateException.getMessage(), illegalStateException);
        }
        catch (OperatorException operatorException) {
            throw new CRMFException("cannot wrap key: " + operatorException.getMessage(), operatorException);
        }
    }

    private EncryptedValue a(byte[] byArray) throws CRMFException {
        DERBitString dERBitString;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = this.b.getOutputStream(byteArrayOutputStream);
        try {
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("cannot process data: " + iOException.getMessage(), iOException);
        }
        AlgorithmIdentifier algorithmIdentifier = null;
        AlgorithmIdentifier algorithmIdentifier2 = this.b.getAlgorithmIdentifier();
        try {
            this.a.generateWrappedKey(this.b.getKey());
            dERBitString = new DERBitString(this.a.generateWrappedKey(this.b.getKey()));
        }
        catch (OperatorException operatorException) {
            throw new CRMFException("cannot wrap key: " + operatorException.getMessage(), operatorException);
        }
        AlgorithmIdentifier algorithmIdentifier3 = this.a.getAlgorithmIdentifier();
        ASN1OctetString aSN1OctetString = null;
        DERBitString dERBitString2 = new DERBitString(byteArrayOutputStream.toByteArray());
        return new EncryptedValue(algorithmIdentifier, algorithmIdentifier2, dERBitString, algorithmIdentifier3, aSN1OctetString, dERBitString2);
    }

    private byte[] b(byte[] byArray) {
        if (this.c != null) {
            return this.c.getPaddedData(byArray);
        }
        return byArray;
    }
}

