/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.cmp;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Choice;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AttributeCertificate;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Certificate;
import java.io.IOException;

public class CMPCertificate
extends ASN1Object
implements ASN1Choice {
    private Certificate a;
    private int b;
    private ASN1Object c;

    public CMPCertificate(AttributeCertificate attributeCertificate) {
        this(1, attributeCertificate);
    }

    public CMPCertificate(int n2, ASN1Object aSN1Object) {
        this.b = n2;
        this.c = aSN1Object;
    }

    public CMPCertificate(Certificate certificate) {
        if (certificate.getVersionNumber() != 3) {
            throw new IllegalArgumentException("only version 3 certificates allowed");
        }
        this.a = certificate;
    }

    public static CMPCertificate getInstance(Object object) {
        if (object == null || object instanceof CMPCertificate) {
            return (CMPCertificate)object;
        }
        if (object instanceof byte[]) {
            try {
                object = ASN1Primitive.fromByteArray((byte[])object);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Invalid encoding in CMPCertificate");
            }
        }
        if (object instanceof ASN1Sequence) {
            return new CMPCertificate(Certificate.getInstance(object));
        }
        if (object instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object;
            return new CMPCertificate(aSN1TaggedObject.getTagNo(), aSN1TaggedObject.getObject());
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    public boolean isX509v3PKCert() {
        return this.a != null;
    }

    public Certificate getX509v3PKCert() {
        return this.a;
    }

    public AttributeCertificate getX509v2AttrCert() {
        return AttributeCertificate.getInstance(this.c);
    }

    public int getOtherCertTag() {
        return this.b;
    }

    public ASN1Object getOtherCert() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.c != null) {
            return new DERTaggedObject(true, this.b, this.c);
        }
        return this.a.toASN1Primitive();
    }
}

