/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.cmc;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERBitString;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.cad.internal.bouncycastle.asn1.x509.ReasonFlags;

public class GetCRL
extends ASN1Object {
    private final X500Name a;
    private GeneralName b;
    private ASN1GeneralizedTime c;
    private ReasonFlags d;

    public GetCRL(X500Name x500Name, GeneralName generalName, ASN1GeneralizedTime aSN1GeneralizedTime, ReasonFlags reasonFlags) {
        this.a = x500Name;
        this.b = generalName;
        this.c = aSN1GeneralizedTime;
        this.d = reasonFlags;
    }

    private GetCRL(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 4) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = X500Name.getInstance(aSN1Sequence.getObjectAt(0));
        int n2 = 1;
        if (aSN1Sequence.size() > n2 && aSN1Sequence.getObjectAt(n2).toASN1Primitive() instanceof ASN1TaggedObject) {
            this.b = GeneralName.getInstance(aSN1Sequence.getObjectAt(n2++));
        }
        if (aSN1Sequence.size() > n2 && aSN1Sequence.getObjectAt(n2).toASN1Primitive() instanceof ASN1GeneralizedTime) {
            this.c = ASN1GeneralizedTime.getInstance(aSN1Sequence.getObjectAt(n2++));
        }
        if (aSN1Sequence.size() > n2 && aSN1Sequence.getObjectAt(n2).toASN1Primitive() instanceof DERBitString) {
            this.d = new ReasonFlags(DERBitString.getInstance(aSN1Sequence.getObjectAt(n2)));
        }
    }

    public static GetCRL getInstance(Object object) {
        if (object instanceof GetCRL) {
            return (GetCRL)object;
        }
        if (object != null) {
            return new GetCRL(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public X500Name getIssuerName() {
        return this.a;
    }

    public GeneralName getcRLName() {
        return this.b;
    }

    public ASN1GeneralizedTime getTime() {
        return this.c;
    }

    public ReasonFlags getReasons() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

