/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.math.ec;

import com.aspose.cad.internal.bouncycastle.math.ec.ECConstants;
import com.aspose.cad.internal.bouncycastle.math.ec.c;
import com.aspose.cad.internal.bouncycastle.math.raw.Mod;
import com.aspose.cad.internal.bouncycastle.math.raw.Nat;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import com.aspose.cad.internal.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract BigInteger toBigInteger();

    public abstract String getFieldName();

    public abstract int getFieldSize();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement addOne();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement negate();

    public abstract ECFieldElement square();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement sqrt();

    public int bitLength() {
        return this.toBigInteger().bitLength();
    }

    public boolean isOne() {
        return this.bitLength() == 1;
    }

    public boolean isZero() {
        return 0 == this.toBigInteger().signum();
    }

    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiply(eCFieldElement).subtract(eCFieldElement2.multiply(eCFieldElement3));
    }

    public ECFieldElement multiplyPlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiply(eCFieldElement).add(eCFieldElement2.multiply(eCFieldElement3));
    }

    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.square().subtract(eCFieldElement.multiply(eCFieldElement2));
    }

    public ECFieldElement squarePlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.square().add(eCFieldElement.multiply(eCFieldElement2));
    }

    public ECFieldElement squarePow(int n2) {
        ECFieldElement eCFieldElement = this;
        for (int i2 = 0; i2 < n2; ++i2) {
            eCFieldElement = eCFieldElement.square();
        }
        return eCFieldElement;
    }

    public boolean testBitZero() {
        return this.toBigInteger().testBit(0);
    }

    public String toString() {
        return this.toBigInteger().toString(16);
    }

    public byte[] getEncoded() {
        return BigIntegers.asUnsignedByteArray((this.getFieldSize() + 7) / 8, this.toBigInteger());
    }

    public static class F2m
    extends ECFieldElement {
        public static final int GNB = 1;
        public static final int TPB = 2;
        public static final int PPB = 3;
        private int a;
        private int b;
        private int[] c;
        c x;

        public F2m(int n2, int n3, int n4, int n5, BigInteger bigInteger) {
            if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.bitLength() > n2) {
                throw new IllegalArgumentException("x value invalid in F2m field element");
            }
            if (n4 == 0 && n5 == 0) {
                this.a = 2;
                this.c = new int[]{n3};
            } else {
                if (n4 >= n5) {
                    throw new IllegalArgumentException("k2 must be smaller than k3");
                }
                if (n4 <= 0) {
                    throw new IllegalArgumentException("k2 must be larger than 0");
                }
                this.a = 3;
                this.c = new int[]{n3, n4, n5};
            }
            this.b = n2;
            this.x = new c(bigInteger);
        }

        public F2m(int n2, int n3, BigInteger bigInteger) {
            this(n2, n3, 0, 0, bigInteger);
        }

        F2m(int n2, int[] nArray, c c2) {
            this.b = n2;
            this.a = nArray.length == 1 ? 2 : 3;
            this.c = nArray;
            this.x = c2;
        }

        @Override
        public int bitLength() {
            return this.x.d();
        }

        @Override
        public boolean isOne() {
            return this.x.a();
        }

        @Override
        public boolean isZero() {
            return this.x.b();
        }

        @Override
        public boolean testBitZero() {
            return this.x.h();
        }

        @Override
        public BigInteger toBigInteger() {
            return this.x.e();
        }

        @Override
        public String getFieldName() {
            return "F2m";
        }

        @Override
        public int getFieldSize() {
            return this.b;
        }

        public static void checkFieldElements(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            if (!(eCFieldElement instanceof F2m) || !(eCFieldElement2 instanceof F2m)) {
                throw new IllegalArgumentException("Field elements are not both instances of ECFieldElement.F2m");
            }
            F2m f2m = (F2m)eCFieldElement;
            F2m f2m2 = (F2m)eCFieldElement2;
            if (f2m.a != f2m2.a) {
                throw new IllegalArgumentException("One of the F2m field elements has incorrect representation");
            }
            if (f2m.b != f2m2.b || !Arrays.areEqual(f2m.c, f2m2.c)) {
                throw new IllegalArgumentException("Field elements are not elements of the same field F2m");
            }
        }

        @Override
        public ECFieldElement add(ECFieldElement eCFieldElement) {
            c c2 = (c)this.x.clone();
            F2m f2m = (F2m)eCFieldElement;
            c2.a(f2m.x, 0);
            return new F2m(this.b, this.c, c2);
        }

        @Override
        public ECFieldElement addOne() {
            return new F2m(this.b, this.c, this.x.f());
        }

        @Override
        public ECFieldElement subtract(ECFieldElement eCFieldElement) {
            return this.add(eCFieldElement);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement eCFieldElement) {
            return new F2m(this.b, this.c, this.x.b(((F2m)eCFieldElement).x, this.b, this.c));
        }

        @Override
        public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
            return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
        }

        @Override
        public ECFieldElement multiplyPlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
            c c2 = this.x;
            c c3 = ((F2m)eCFieldElement).x;
            c c4 = ((F2m)eCFieldElement2).x;
            c c5 = ((F2m)eCFieldElement3).x;
            c c6 = c2.d(c3, this.b, this.c);
            c c7 = c4.d(c5, this.b, this.c);
            if (c6 == c2 || c6 == c3) {
                c6 = (c)c6.clone();
            }
            c6.a(c7, 0);
            c6.b(this.b, this.c);
            return new F2m(this.b, this.c, c6);
        }

        @Override
        public ECFieldElement divide(ECFieldElement eCFieldElement) {
            ECFieldElement eCFieldElement2 = eCFieldElement.invert();
            return this.multiply(eCFieldElement2);
        }

        @Override
        public ECFieldElement negate() {
            return this;
        }

        @Override
        public ECFieldElement square() {
            return new F2m(this.b, this.c, this.x.c(this.b, this.c));
        }

        @Override
        public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
        }

        @Override
        public ECFieldElement squarePlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            c c2 = this.x;
            c c3 = ((F2m)eCFieldElement).x;
            c c4 = ((F2m)eCFieldElement2).x;
            c c5 = c2.d(this.b, this.c);
            c c6 = c3.d(c4, this.b, this.c);
            if (c5 == c2) {
                c5 = (c)c5.clone();
            }
            c5.a(c6, 0);
            c5.b(this.b, this.c);
            return new F2m(this.b, this.c, c5);
        }

        @Override
        public ECFieldElement squarePow(int n2) {
            return n2 < 1 ? this : new F2m(this.b, this.c, this.x.a(n2, this.b, this.c));
        }

        @Override
        public ECFieldElement invert() {
            return new F2m(this.b, this.c, this.x.e(this.b, this.c));
        }

        @Override
        public ECFieldElement sqrt() {
            return this.x.b() || this.x.a() ? this : this.squarePow(this.b - 1);
        }

        public int getRepresentation() {
            return this.a;
        }

        public int getM() {
            return this.b;
        }

        public int getK1() {
            return this.c[0];
        }

        public int getK2() {
            return this.c.length >= 2 ? this.c[1] : 0;
        }

        public int getK3() {
            return this.c.length >= 3 ? this.c[2] : 0;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)object;
            return this.b == f2m.b && this.a == f2m.a && Arrays.areEqual(this.c, f2m.c) && this.x.equals(f2m.x);
        }

        public int hashCode() {
            return this.x.hashCode() ^ this.b ^ Arrays.hashCode(this.c);
        }
    }

    public static class Fp
    extends ECFieldElement {
        BigInteger q;
        BigInteger r;
        BigInteger x;

        static BigInteger calculateResidue(BigInteger bigInteger) {
            BigInteger bigInteger2;
            int n2 = bigInteger.bitLength();
            if (n2 >= 96 && (bigInteger2 = bigInteger.shiftRight(n2 - 64)).longValue() == -1L) {
                return ONE.shiftLeft(n2).subtract(bigInteger);
            }
            return null;
        }

        public Fp(BigInteger bigInteger, BigInteger bigInteger2) {
            this(bigInteger, Fp.calculateResidue(bigInteger), bigInteger2);
        }

        Fp(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            if (bigInteger3 == null || bigInteger3.signum() < 0 || bigInteger3.compareTo(bigInteger) >= 0) {
                throw new IllegalArgumentException("x value invalid in Fp field element");
            }
            this.q = bigInteger;
            this.r = bigInteger2;
            this.x = bigInteger3;
        }

        @Override
        public BigInteger toBigInteger() {
            return this.x;
        }

        @Override
        public String getFieldName() {
            return "Fp";
        }

        @Override
        public int getFieldSize() {
            return this.q.bitLength();
        }

        public BigInteger getQ() {
            return this.q;
        }

        @Override
        public ECFieldElement add(ECFieldElement eCFieldElement) {
            return new Fp(this.q, this.r, this.modAdd(this.x, eCFieldElement.toBigInteger()));
        }

        @Override
        public ECFieldElement addOne() {
            BigInteger bigInteger = this.x.add(ECConstants.ONE);
            if (bigInteger.compareTo(this.q) == 0) {
                bigInteger = ECConstants.ZERO;
            }
            return new Fp(this.q, this.r, bigInteger);
        }

        @Override
        public ECFieldElement subtract(ECFieldElement eCFieldElement) {
            return new Fp(this.q, this.r, this.modSubtract(this.x, eCFieldElement.toBigInteger()));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement eCFieldElement) {
            return new Fp(this.q, this.r, this.modMult(this.x, eCFieldElement.toBigInteger()));
        }

        @Override
        public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
            BigInteger bigInteger = this.x;
            BigInteger bigInteger2 = eCFieldElement.toBigInteger();
            BigInteger bigInteger3 = eCFieldElement2.toBigInteger();
            BigInteger bigInteger4 = eCFieldElement3.toBigInteger();
            BigInteger bigInteger5 = bigInteger.multiply(bigInteger2);
            BigInteger bigInteger6 = bigInteger3.multiply(bigInteger4);
            return new Fp(this.q, this.r, this.modReduce(bigInteger5.subtract(bigInteger6)));
        }

        @Override
        public ECFieldElement multiplyPlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
            BigInteger bigInteger = this.x;
            BigInteger bigInteger2 = eCFieldElement.toBigInteger();
            BigInteger bigInteger3 = eCFieldElement2.toBigInteger();
            BigInteger bigInteger4 = eCFieldElement3.toBigInteger();
            BigInteger bigInteger5 = bigInteger.multiply(bigInteger2);
            BigInteger bigInteger6 = bigInteger3.multiply(bigInteger4);
            return new Fp(this.q, this.r, this.modReduce(bigInteger5.add(bigInteger6)));
        }

        @Override
        public ECFieldElement divide(ECFieldElement eCFieldElement) {
            return new Fp(this.q, this.r, this.modMult(this.x, this.modInverse(eCFieldElement.toBigInteger())));
        }

        @Override
        public ECFieldElement negate() {
            return this.x.signum() == 0 ? this : new Fp(this.q, this.r, this.q.subtract(this.x));
        }

        @Override
        public ECFieldElement square() {
            return new Fp(this.q, this.r, this.modMult(this.x, this.x));
        }

        @Override
        public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            BigInteger bigInteger = this.x;
            BigInteger bigInteger2 = eCFieldElement.toBigInteger();
            BigInteger bigInteger3 = eCFieldElement2.toBigInteger();
            BigInteger bigInteger4 = bigInteger.multiply(bigInteger);
            BigInteger bigInteger5 = bigInteger2.multiply(bigInteger3);
            return new Fp(this.q, this.r, this.modReduce(bigInteger4.subtract(bigInteger5)));
        }

        @Override
        public ECFieldElement squarePlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            BigInteger bigInteger = this.x;
            BigInteger bigInteger2 = eCFieldElement.toBigInteger();
            BigInteger bigInteger3 = eCFieldElement2.toBigInteger();
            BigInteger bigInteger4 = bigInteger.multiply(bigInteger);
            BigInteger bigInteger5 = bigInteger2.multiply(bigInteger3);
            return new Fp(this.q, this.r, this.modReduce(bigInteger4.add(bigInteger5)));
        }

        @Override
        public ECFieldElement invert() {
            return new Fp(this.q, this.r, this.modInverse(this.x));
        }

        @Override
        public ECFieldElement sqrt() {
            if (this.isZero() || this.isOne()) {
                return this;
            }
            if (!this.q.testBit(0)) {
                throw new RuntimeException("not done yet");
            }
            if (this.q.testBit(1)) {
                BigInteger bigInteger = this.q.shiftRight(2).add(ECConstants.ONE);
                return this.a(new Fp(this.q, this.r, this.x.modPow(bigInteger, this.q)));
            }
            if (this.q.testBit(2)) {
                BigInteger bigInteger = this.x.modPow(this.q.shiftRight(3), this.q);
                BigInteger bigInteger2 = this.modMult(bigInteger, this.x);
                BigInteger bigInteger3 = this.modMult(bigInteger2, bigInteger);
                if (bigInteger3.equals(ECConstants.ONE)) {
                    return this.a(new Fp(this.q, this.r, bigInteger2));
                }
                BigInteger bigInteger4 = ECConstants.TWO.modPow(this.q.shiftRight(2), this.q);
                BigInteger bigInteger5 = this.modMult(bigInteger2, bigInteger4);
                return this.a(new Fp(this.q, this.r, bigInteger5));
            }
            BigInteger bigInteger = this.q.shiftRight(1);
            if (!this.x.modPow(bigInteger, this.q).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger6 = this.x;
            BigInteger bigInteger7 = this.modDouble(this.modDouble(bigInteger6));
            BigInteger bigInteger8 = bigInteger.add(ECConstants.ONE);
            BigInteger bigInteger9 = this.q.subtract(ECConstants.ONE);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger10;
                if ((bigInteger10 = new BigInteger(this.q.bitLength(), random)).compareTo(this.q) >= 0 || !this.modReduce(bigInteger10.multiply(bigInteger10).subtract(bigInteger7)).modPow(bigInteger, this.q).equals(bigInteger9)) {
                    continue;
                }
                BigInteger[] bigIntegerArray = this.a(bigInteger10, bigInteger6, bigInteger8);
                BigInteger bigInteger11 = bigIntegerArray[0];
                BigInteger bigInteger12 = bigIntegerArray[1];
                if (this.modMult(bigInteger12, bigInteger12).equals(bigInteger7)) {
                    return new Fp(this.q, this.r, this.modHalfAbs(bigInteger12));
                }
                if (!bigInteger11.equals(ECConstants.ONE) && !bigInteger11.equals(bigInteger9)) break;
            }
            return null;
        }

        private ECFieldElement a(ECFieldElement eCFieldElement) {
            return eCFieldElement.square().equals(this) ? eCFieldElement : null;
        }

        private BigInteger[] a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            int n2;
            int n3 = bigInteger3.bitLength();
            int n4 = bigInteger3.getLowestSetBit();
            BigInteger bigInteger4 = ECConstants.ONE;
            BigInteger bigInteger5 = ECConstants.TWO;
            BigInteger bigInteger6 = bigInteger;
            BigInteger bigInteger7 = ECConstants.ONE;
            BigInteger bigInteger8 = ECConstants.ONE;
            for (n2 = n3 - 1; n2 >= n4 + 1; --n2) {
                bigInteger7 = this.modMult(bigInteger7, bigInteger8);
                if (bigInteger3.testBit(n2)) {
                    bigInteger8 = this.modMult(bigInteger7, bigInteger2);
                    bigInteger4 = this.modMult(bigInteger4, bigInteger6);
                    bigInteger5 = this.modReduce(bigInteger6.multiply(bigInteger5).subtract(bigInteger.multiply(bigInteger7)));
                    bigInteger6 = this.modReduce(bigInteger6.multiply(bigInteger6).subtract(bigInteger8.shiftLeft(1)));
                    continue;
                }
                bigInteger8 = bigInteger7;
                bigInteger4 = this.modReduce(bigInteger4.multiply(bigInteger5).subtract(bigInteger7));
                bigInteger6 = this.modReduce(bigInteger6.multiply(bigInteger5).subtract(bigInteger.multiply(bigInteger7)));
                bigInteger5 = this.modReduce(bigInteger5.multiply(bigInteger5).subtract(bigInteger7.shiftLeft(1)));
            }
            bigInteger7 = this.modMult(bigInteger7, bigInteger8);
            bigInteger8 = this.modMult(bigInteger7, bigInteger2);
            bigInteger4 = this.modReduce(bigInteger4.multiply(bigInteger5).subtract(bigInteger7));
            bigInteger5 = this.modReduce(bigInteger6.multiply(bigInteger5).subtract(bigInteger.multiply(bigInteger7)));
            bigInteger7 = this.modMult(bigInteger7, bigInteger8);
            for (n2 = 1; n2 <= n4; ++n2) {
                bigInteger4 = this.modMult(bigInteger4, bigInteger5);
                bigInteger5 = this.modReduce(bigInteger5.multiply(bigInteger5).subtract(bigInteger7.shiftLeft(1)));
                bigInteger7 = this.modMult(bigInteger7, bigInteger7);
            }
            return new BigInteger[]{bigInteger4, bigInteger5};
        }

        protected BigInteger modAdd(BigInteger bigInteger, BigInteger bigInteger2) {
            BigInteger bigInteger3 = bigInteger.add(bigInteger2);
            if (bigInteger3.compareTo(this.q) >= 0) {
                bigInteger3 = bigInteger3.subtract(this.q);
            }
            return bigInteger3;
        }

        protected BigInteger modDouble(BigInteger bigInteger) {
            BigInteger bigInteger2 = bigInteger.shiftLeft(1);
            if (bigInteger2.compareTo(this.q) >= 0) {
                bigInteger2 = bigInteger2.subtract(this.q);
            }
            return bigInteger2;
        }

        protected BigInteger modHalf(BigInteger bigInteger) {
            if (bigInteger.testBit(0)) {
                bigInteger = this.q.add(bigInteger);
            }
            return bigInteger.shiftRight(1);
        }

        protected BigInteger modHalfAbs(BigInteger bigInteger) {
            if (bigInteger.testBit(0)) {
                bigInteger = this.q.subtract(bigInteger);
            }
            return bigInteger.shiftRight(1);
        }

        protected BigInteger modInverse(BigInteger bigInteger) {
            int n2 = this.getFieldSize();
            int n3 = n2 + 31 >> 5;
            int[] nArray = Nat.fromBigInteger(n2, this.q);
            int[] nArray2 = Nat.fromBigInteger(n2, bigInteger);
            int[] nArray3 = Nat.create(n3);
            Mod.invert(nArray, nArray2, nArray3);
            return Nat.toBigInteger(n3, nArray3);
        }

        protected BigInteger modMult(BigInteger bigInteger, BigInteger bigInteger2) {
            return this.modReduce(bigInteger.multiply(bigInteger2));
        }

        protected BigInteger modReduce(BigInteger bigInteger) {
            if (this.r != null) {
                boolean bl2;
                boolean bl3 = bl2 = bigInteger.signum() < 0;
                if (bl2) {
                    bigInteger = bigInteger.abs();
                }
                int n2 = this.q.bitLength();
                boolean bl4 = this.r.equals(ECConstants.ONE);
                while (bigInteger.bitLength() > n2 + 1) {
                    BigInteger bigInteger2 = bigInteger.shiftRight(n2);
                    BigInteger bigInteger3 = bigInteger.subtract(bigInteger2.shiftLeft(n2));
                    if (!bl4) {
                        bigInteger2 = bigInteger2.multiply(this.r);
                    }
                    bigInteger = bigInteger2.add(bigInteger3);
                }
                while (bigInteger.compareTo(this.q) >= 0) {
                    bigInteger = bigInteger.subtract(this.q);
                }
                if (bl2 && bigInteger.signum() != 0) {
                    bigInteger = this.q.subtract(bigInteger);
                }
            } else {
                bigInteger = bigInteger.mod(this.q);
            }
            return bigInteger;
        }

        protected BigInteger modSubtract(BigInteger bigInteger, BigInteger bigInteger2) {
            BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
            if (bigInteger3.signum() < 0) {
                bigInteger3 = bigInteger3.add(this.q);
            }
            return bigInteger3;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Fp)) {
                return false;
            }
            Fp fp2 = (Fp)object;
            return this.q.equals(fp2.q) && this.x.equals(fp2.x);
        }

        public int hashCode() {
            return this.q.hashCode() ^ this.x.hashCode();
        }
    }
}

