/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.dsa;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.DERNull;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.DSAParameter;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.aspose.cad.internal.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPublicKeySpec;

public class BCDSAPublicKey
implements DSAPublicKey {
    private static final long a = 1752452449903495175L;
    private static BigInteger b = BigInteger.valueOf(0L);
    private BigInteger c;
    private transient DSAPublicKeyParameters d;
    private transient DSAParams e;

    BCDSAPublicKey(DSAPublicKeySpec dSAPublicKeySpec) {
        this.c = dSAPublicKeySpec.getY();
        this.e = new DSAParameterSpec(dSAPublicKeySpec.getP(), dSAPublicKeySpec.getQ(), dSAPublicKeySpec.getG());
        this.d = new DSAPublicKeyParameters(this.c, DSAUtil.toDSAParameters(this.e));
    }

    BCDSAPublicKey(DSAPublicKey dSAPublicKey) {
        this.c = dSAPublicKey.getY();
        this.e = dSAPublicKey.getParams();
        this.d = new DSAPublicKeyParameters(this.c, DSAUtil.toDSAParameters(this.e));
    }

    BCDSAPublicKey(DSAPublicKeyParameters dSAPublicKeyParameters) {
        this.c = dSAPublicKeyParameters.getY();
        this.e = dSAPublicKeyParameters != null ? new DSAParameterSpec(dSAPublicKeyParameters.getParameters().getP(), dSAPublicKeyParameters.getParameters().getQ(), dSAPublicKeyParameters.getParameters().getG()) : null;
        this.d = dSAPublicKeyParameters;
    }

    public BCDSAPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        ASN1Integer aSN1Integer;
        try {
            aSN1Integer = (ASN1Integer)subjectPublicKeyInfo.parsePublicKey();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in DSA public key");
        }
        this.c = aSN1Integer.getValue();
        if (this.a(subjectPublicKeyInfo.getAlgorithm().getParameters())) {
            DSAParameter dSAParameter = DSAParameter.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            this.e = new DSAParameterSpec(dSAParameter.getP(), dSAParameter.getQ(), dSAParameter.getG());
        } else {
            this.e = null;
        }
        this.d = new DSAPublicKeyParameters(this.c, DSAUtil.toDSAParameters(this.e));
    }

    private boolean a(ASN1Encodable aSN1Encodable) {
        return aSN1Encodable != null && !DERNull.INSTANCE.equals(aSN1Encodable.toASN1Primitive());
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    DSAPublicKeyParameters engineGetKeyParameters() {
        return this.d;
    }

    @Override
    public byte[] getEncoded() {
        if (this.e == null) {
            return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa), new ASN1Integer(this.c));
        }
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(this.e.getP(), this.e.getQ(), this.e.getG()).toASN1Primitive()), new ASN1Integer(this.c));
    }

    @Override
    public DSAParams getParams() {
        return this.e;
    }

    @Override
    public BigInteger getY() {
        return this.c;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("DSA Public Key [").append(DSAUtil.generateKeyFingerprint(this.c, this.getParams())).append("]").append(string);
        stringBuffer.append("            y: ").append(this.getY().toString(16)).append(string);
        return stringBuffer.toString();
    }

    public int hashCode() {
        if (this.e != null) {
            return this.getY().hashCode() ^ this.getParams().getG().hashCode() ^ this.getParams().getP().hashCode() ^ this.getParams().getQ().hashCode();
        }
        return this.getY().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DSAPublicKey)) {
            return false;
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)object;
        if (this.e != null) {
            return this.getY().equals(dSAPublicKey.getY()) && dSAPublicKey.getParams() != null && this.getParams().getG().equals(dSAPublicKey.getParams().getG()) && this.getParams().getP().equals(dSAPublicKey.getParams().getP()) && this.getParams().getQ().equals(dSAPublicKey.getParams().getQ());
        }
        return this.getY().equals(dSAPublicKey.getY()) && dSAPublicKey.getParams() == null;
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        BigInteger bigInteger = (BigInteger)objectInputStream.readObject();
        this.e = bigInteger.equals(b) ? null : new DSAParameterSpec(bigInteger, (BigInteger)objectInputStream.readObject(), (BigInteger)objectInputStream.readObject());
        this.d = new DSAPublicKeyParameters(this.c, DSAUtil.toDSAParameters(this.e));
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.e == null) {
            objectOutputStream.writeObject(b);
        } else {
            objectOutputStream.writeObject(this.e.getP());
            objectOutputStream.writeObject(this.e.getQ());
            objectOutputStream.writeObject(this.e.getG());
        }
    }
}

