/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cmc;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.cad.internal.bouncycastle.cert.X509CRLHolder;
import com.aspose.cad.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.cad.internal.bouncycastle.cmc.CMCException;
import com.aspose.cad.internal.bouncycastle.cms.CMSException;
import com.aspose.cad.internal.bouncycastle.cms.CMSSignedData;
import com.aspose.cad.internal.bouncycastle.util.Encodable;
import com.aspose.cad.internal.bouncycastle.util.Store;
import java.io.IOException;

public class SimplePKIResponse
implements Encodable {
    private final CMSSignedData a;

    private static ContentInfo a(byte[] byArray) throws CMCException {
        try {
            return ContentInfo.getInstance(ASN1Primitive.fromByteArray(byArray));
        }
        catch (Exception exception) {
            throw new CMCException("malformed data: " + exception.getMessage(), exception);
        }
    }

    public SimplePKIResponse(byte[] byArray) throws CMCException {
        this(SimplePKIResponse.a(byArray));
    }

    public SimplePKIResponse(ContentInfo contentInfo) throws CMCException {
        try {
            this.a = new CMSSignedData(contentInfo);
        }
        catch (CMSException cMSException) {
            throw new CMCException("malformed response: " + cMSException.getMessage(), cMSException);
        }
        if (this.a.getSignerInfos().size() != 0) {
            throw new CMCException("malformed response: SignerInfo structures found");
        }
        if (this.a.getSignedContent() != null) {
            throw new CMCException("malformed response: Signed Content found");
        }
    }

    public Store<X509CertificateHolder> getCertificates() {
        return this.a.getCertificates();
    }

    public Store<X509CRLHolder> getCRLs() {
        return this.a.getCRLs();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.a.getEncoded();
    }
}

