/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.pqc.jcajce.spec;

import com.aspose.cad.internal.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;

public class McElieceKeyGenParameterSpec
implements AlgorithmParameterSpec {
    public static final int DEFAULT_M = 11;
    public static final int DEFAULT_T = 50;
    private int a;
    private int b;
    private int c;
    private int d;

    public McElieceKeyGenParameterSpec() {
        this(11, 50);
    }

    public McElieceKeyGenParameterSpec(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("key size must be positive");
        }
        this.a = 0;
        this.c = 1;
        while (this.c < n2) {
            this.c <<= 1;
            ++this.a;
        }
        this.b = this.c >>> 1;
        this.b /= this.a;
        this.d = PolynomialRingGF2.getIrreduciblePolynomial(this.a);
    }

    public McElieceKeyGenParameterSpec(int n2, int n3) throws InvalidParameterException {
        if (n2 < 1) {
            throw new IllegalArgumentException("m must be positive");
        }
        if (n2 > 32) {
            throw new IllegalArgumentException("m is too large");
        }
        this.a = n2;
        this.c = 1 << n2;
        if (n3 < 0) {
            throw new IllegalArgumentException("t must be positive");
        }
        if (n3 > this.c) {
            throw new IllegalArgumentException("t must be less than n = 2^m");
        }
        this.b = n3;
        this.d = PolynomialRingGF2.getIrreduciblePolynomial(n2);
    }

    public McElieceKeyGenParameterSpec(int n2, int n3, int n4) {
        this.a = n2;
        if (n2 < 1) {
            throw new IllegalArgumentException("m must be positive");
        }
        if (n2 > 32) {
            throw new IllegalArgumentException(" m is too large");
        }
        this.c = 1 << n2;
        this.b = n3;
        if (n3 < 0) {
            throw new IllegalArgumentException("t must be positive");
        }
        if (n3 > this.c) {
            throw new IllegalArgumentException("t must be less than n = 2^m");
        }
        if (PolynomialRingGF2.degree(n4) != n2 || !PolynomialRingGF2.isIrreducible(n4)) {
            throw new IllegalArgumentException("polynomial is not a field polynomial for GF(2^m)");
        }
        this.d = n4;
    }

    public int getM() {
        return this.a;
    }

    public int getN() {
        return this.c;
    }

    public int getT() {
        return this.b;
    }

    public int getFieldPoly() {
        return this.d;
    }
}

