/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.pqc.jcajce.provider.mceliece;

import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.cad.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.cad.internal.bouncycastle.pqc.asn1.McEliecePublicKey;
import com.aspose.cad.internal.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import com.aspose.cad.internal.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import java.io.IOException;
import java.security.PublicKey;

public class BCMcEliecePublicKey
implements PublicKey {
    private static final long a = 1L;
    private McEliecePublicKeyParameters b;

    public BCMcEliecePublicKey(McEliecePublicKeyParameters mcEliecePublicKeyParameters) {
        this.b = mcEliecePublicKeyParameters;
    }

    @Override
    public String getAlgorithm() {
        return "McEliece";
    }

    public int getN() {
        return this.b.getN();
    }

    public int getK() {
        return this.b.getK();
    }

    public int getT() {
        return this.b.getT();
    }

    public GF2Matrix getG() {
        return this.b.getG();
    }

    public String toString() {
        String string = "McEliecePublicKey:\n";
        string = string + " length of the code         : " + this.b.getN() + "\n";
        string = string + " error correction capability: " + this.b.getT() + "\n";
        string = string + " generator matrix           : " + this.b.getG();
        return string;
    }

    public boolean equals(Object object) {
        if (object instanceof BCMcEliecePublicKey) {
            BCMcEliecePublicKey bCMcEliecePublicKey = (BCMcEliecePublicKey)object;
            return this.b.getN() == bCMcEliecePublicKey.getN() && this.b.getT() == bCMcEliecePublicKey.getT() && this.b.getG().equals(bCMcEliecePublicKey.getG());
        }
        return false;
    }

    public int hashCode() {
        return 37 * (this.b.getN() + 37 * this.b.getT()) + this.b.getG().hashCode();
    }

    @Override
    public byte[] getEncoded() {
        McEliecePublicKey mcEliecePublicKey = new McEliecePublicKey(this.b.getN(), this.b.getT(), this.b.getG());
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcEliece);
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, mcEliecePublicKey);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    AsymmetricKeyParameter getKeyParams() {
        return this.b;
    }
}

