/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.operator.bc;

import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.cad.internal.bouncycastle.crypto.ExtendedDigest;
import com.aspose.cad.internal.bouncycastle.crypto.Signer;
import com.aspose.cad.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.signers.DSADigestSigner;
import com.aspose.cad.internal.bouncycastle.crypto.signers.ECDSASigner;
import com.aspose.cad.internal.bouncycastle.crypto.util.PublicKeyFactory;
import com.aspose.cad.internal.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.aspose.cad.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.cad.internal.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import java.io.IOException;

public class BcECContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder a;

    public BcECContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.a = digestAlgorithmIdentifierFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.a.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new DSADigestSigner(new ECDSASigner(), extendedDigest);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

