/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.openssl.jcajce;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jcajce.util.JcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.openssl.PEMException;
import com.aspose.cad.internal.bouncycastle.openssl.PEMKeyPair;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

public class JcaPEMKeyConverter {
    private JcaJceHelper a = new DefaultJcaJceHelper();
    private static final Map b = new HashMap();

    public JcaPEMKeyConverter setProvider(Provider provider) {
        this.a = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcaPEMKeyConverter setProvider(String string) {
        this.a = new NamedJcaJceHelper(string);
        return this;
    }

    public KeyPair getKeyPair(PEMKeyPair pEMKeyPair) throws PEMException {
        try {
            KeyFactory keyFactory = this.a(pEMKeyPair.getPrivateKeyInfo().getPrivateKeyAlgorithm());
            return new KeyPair(keyFactory.generatePublic(new X509EncodedKeySpec(pEMKeyPair.getPublicKeyInfo().getEncoded())), keyFactory.generatePrivate(new PKCS8EncodedKeySpec(pEMKeyPair.getPrivateKeyInfo().getEncoded())));
        }
        catch (Exception exception) {
            throw new PEMException("unable to convert key pair: " + exception.getMessage(), exception);
        }
    }

    public PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws PEMException {
        try {
            KeyFactory keyFactory = this.a(subjectPublicKeyInfo.getAlgorithm());
            return keyFactory.generatePublic(new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded()));
        }
        catch (Exception exception) {
            throw new PEMException("unable to convert key pair: " + exception.getMessage(), exception);
        }
    }

    public PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws PEMException {
        try {
            KeyFactory keyFactory = this.a(privateKeyInfo.getPrivateKeyAlgorithm());
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded()));
        }
        catch (Exception exception) {
            throw new PEMException("unable to convert key pair: " + exception.getMessage(), exception);
        }
    }

    private KeyFactory a(AlgorithmIdentifier algorithmIdentifier) throws NoSuchAlgorithmException, NoSuchProviderException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        String string = (String)b.get(aSN1ObjectIdentifier);
        if (string == null) {
            string = aSN1ObjectIdentifier.getId();
        }
        try {
            return this.a.createKeyFactory(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (string.equals("ECDSA")) {
                return this.a.createKeyFactory("EC");
            }
            throw noSuchAlgorithmException;
        }
    }

    static {
        b.put(X9ObjectIdentifiers.id_ecPublicKey, "ECDSA");
        b.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        b.put(X9ObjectIdentifiers.id_dsa, "DSA");
    }
}

