/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.ec;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.DERNull;
import com.aspose.cad.internal.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X962Parameters;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9ECParameters;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.ec.a;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.aspose.cad.internal.bouncycastle.jce.provider.BouncyCastleProvider;
import com.aspose.cad.internal.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.aspose.cad.internal.bouncycastle.jce.spec.ECParameterSpec;
import com.aspose.cad.internal.bouncycastle.math.ec.ECCurve;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class AlgorithmParametersSpi
extends java.security.AlgorithmParametersSpi {
    private java.security.spec.ECParameterSpec a;
    private String b;

    protected boolean isASN1FormatString(String string) {
        return string == null || string.equals("ASN.1");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)algorithmParameterSpec;
            X9ECParameters x9ECParameters = com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a(eCGenParameterSpec);
            if (x9ECParameters == null) {
                throw new InvalidParameterSpecException("EC curve name not recognized: " + eCGenParameterSpec.getName());
            }
            this.b = eCGenParameterSpec.getName();
            this.a = EC5Util.convertToSpec(x9ECParameters);
        } else if (algorithmParameterSpec instanceof java.security.spec.ECParameterSpec) {
            this.b = algorithmParameterSpec instanceof ECNamedCurveSpec ? ((ECNamedCurveSpec)algorithmParameterSpec).getName() : null;
            this.a = (java.security.spec.ECParameterSpec)algorithmParameterSpec;
        } else {
            throw new InvalidParameterSpecException("AlgorithmParameterSpec class not recognized: " + algorithmParameterSpec.getClass().getName());
        }
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        this.engineInit(byArray, "ASN.1");
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        ECCurve eCCurve;
        X962Parameters x962Parameters;
        if (this.isASN1FormatString(string)) {
            x962Parameters = X962Parameters.getInstance(byArray);
            eCCurve = EC5Util.getCurve(BouncyCastleProvider.CONFIGURATION, x962Parameters);
            if (x962Parameters.isNamedCurve()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance(x962Parameters.getParameters());
                this.b = ECNamedCurveTable.getName(aSN1ObjectIdentifier);
                if (this.b == null) {
                    this.b = aSN1ObjectIdentifier.getId();
                }
            }
        } else {
            throw new IOException("Unknown encoded parameters format in AlgorithmParameters object: " + string);
        }
        this.a = EC5Util.convertToSpec(x962Parameters, eCCurve);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (java.security.spec.ECParameterSpec.class.isAssignableFrom(clazz) || clazz == AlgorithmParameterSpec.class) {
            return (T)this.a;
        }
        if (ECGenParameterSpec.class.isAssignableFrom(clazz)) {
            if (this.b != null) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ECUtil.getNamedCurveOid(this.b);
                if (aSN1ObjectIdentifier != null) {
                    return (T)new ECGenParameterSpec(aSN1ObjectIdentifier.getId());
                }
                return (T)new ECGenParameterSpec(this.b);
            }
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ECUtil.getNamedCurveOid(EC5Util.convertSpec(this.a, false));
            if (aSN1ObjectIdentifier != null) {
                return (T)new ECGenParameterSpec(aSN1ObjectIdentifier.getId());
            }
        }
        throw new InvalidParameterSpecException("EC AlgorithmParameters cannot convert to " + clazz.getName());
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded("ASN.1");
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        if (this.isASN1FormatString(string)) {
            X962Parameters x962Parameters;
            if (this.a == null) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else if (this.b != null) {
                x962Parameters = new X962Parameters(ECUtil.getNamedCurveOid(this.b));
            } else {
                ECParameterSpec eCParameterSpec = EC5Util.convertSpec(this.a, false);
                X9ECParameters x9ECParameters = new X9ECParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed());
                x962Parameters = new X962Parameters(x9ECParameters);
            }
            return x962Parameters.getEncoded();
        }
        throw new IOException("Unknown parameters format in AlgorithmParameters object: " + string);
    }

    @Override
    protected String engineToString() {
        return "EC AlgorithmParameters ";
    }
}

