/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.dvcs;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.cad.internal.bouncycastle.asn1.cms.SignedData;
import com.aspose.cad.internal.bouncycastle.asn1.dvcs.DVCSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.dvcs.ServiceType;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.cad.internal.bouncycastle.cms.CMSSignedData;
import com.aspose.cad.internal.bouncycastle.dvcs.CCPDRequestData;
import com.aspose.cad.internal.bouncycastle.dvcs.CPDRequestData;
import com.aspose.cad.internal.bouncycastle.dvcs.DVCSConstructionException;
import com.aspose.cad.internal.bouncycastle.dvcs.DVCSMessage;
import com.aspose.cad.internal.bouncycastle.dvcs.DVCSRequestData;
import com.aspose.cad.internal.bouncycastle.dvcs.DVCSRequestInfo;
import com.aspose.cad.internal.bouncycastle.dvcs.VPKCRequestData;
import com.aspose.cad.internal.bouncycastle.dvcs.VSDRequestData;

public class DVCSRequest
extends DVCSMessage {
    private com.aspose.cad.internal.bouncycastle.asn1.dvcs.DVCSRequest a;
    private DVCSRequestInfo b;
    private DVCSRequestData c;

    public DVCSRequest(CMSSignedData cMSSignedData) throws DVCSConstructionException {
        this(SignedData.getInstance(cMSSignedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSRequest(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSRequestData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Request");
        }
        try {
            this.a = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? com.aspose.cad.internal.bouncycastle.asn1.dvcs.DVCSRequest.getInstance(contentInfo.getContent()) : com.aspose.cad.internal.bouncycastle.asn1.dvcs.DVCSRequest.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception exception) {
            throw new DVCSConstructionException("Unable to parse content: " + exception.getMessage(), exception);
        }
        this.b = new DVCSRequestInfo(this.a.getRequestInformation());
        int n2 = this.b.getServiceType();
        if (n2 == ServiceType.CPD.getValue().intValue()) {
            this.c = new CPDRequestData(this.a.getData());
        } else if (n2 == ServiceType.VSD.getValue().intValue()) {
            this.c = new VSDRequestData(this.a.getData());
        } else if (n2 == ServiceType.VPKC.getValue().intValue()) {
            this.c = new VPKCRequestData(this.a.getData());
        } else if (n2 == ServiceType.CCPD.getValue().intValue()) {
            this.c = new CCPDRequestData(this.a.getData());
        } else {
            throw new DVCSConstructionException("Unknown service type: " + n2);
        }
    }

    @Override
    public ASN1Encodable getContent() {
        return this.a;
    }

    public DVCSRequestInfo getRequestInfo() {
        return this.b;
    }

    public DVCSRequestData getData() {
        return this.c;
    }

    public GeneralName getTransactionIdentifier() {
        return this.a.getTransactionIdentifier();
    }
}

