/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.modes;

import com.aspose.cad.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.StreamBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.modes.CFBBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithSBox;

public class GCFBBlockCipher
extends StreamBlockCipher {
    private static final byte[] a = new byte[]{105, 0, 114, 34, 100, -55, 4, 35, -115, 58, -37, -106, 70, -23, 42, -60, 24, -2, -84, -108, 0, -19, 7, 18, -64, -122, -36, -62, -17, 76, -87, 43};
    private final CFBBlockCipher b;
    private KeyParameter c;
    private long d = 0L;
    private boolean e;

    public GCFBBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.b = new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8);
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.d = 0L;
        this.b.init(bl2, cipherParameters);
        this.e = bl2;
        if (cipherParameters instanceof ParametersWithIV) {
            cipherParameters = ((ParametersWithIV)cipherParameters).getParameters();
        }
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        if (cipherParameters instanceof ParametersWithSBox) {
            cipherParameters = ((ParametersWithSBox)cipherParameters).getParameters();
        }
        this.c = (KeyParameter)cipherParameters;
    }

    @Override
    public String getAlgorithmName() {
        String string = this.b.getAlgorithmName();
        return string.substring(0, string.indexOf(47)) + "/G" + string.substring(string.indexOf(47) + 1);
    }

    @Override
    public int getBlockSize() {
        return this.b.getBlockSize();
    }

    @Override
    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n2, this.b.getBlockSize(), byArray2, n3);
        return this.b.getBlockSize();
    }

    @Override
    protected byte calculateByte(byte by2) {
        if (this.d > 0L && this.d % 1024L == 0L) {
            BlockCipher blockCipher = this.b.getUnderlyingCipher();
            blockCipher.init(false, this.c);
            byte[] byArray = new byte[32];
            blockCipher.processBlock(a, 0, byArray, 0);
            blockCipher.processBlock(a, 8, byArray, 8);
            blockCipher.processBlock(a, 16, byArray, 16);
            blockCipher.processBlock(a, 24, byArray, 24);
            this.c = new KeyParameter(byArray);
            blockCipher.init(true, this.c);
            byte[] byArray2 = this.b.getCurrentIV();
            blockCipher.processBlock(byArray2, 0, byArray2, 0);
            this.b.init(this.e, new ParametersWithIV(this.c, byArray2));
        }
        ++this.d;
        return this.b.calculateByte(by2);
    }

    @Override
    public void reset() {
        this.d = 0L;
        this.b.reset();
    }
}

