/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.generators;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.Digest;
import com.aspose.cad.internal.bouncycastle.crypto.ExtendedDigest;
import com.aspose.cad.internal.bouncycastle.crypto.PBEParametersGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithIV;

public class PKCS12ParametersGenerator
extends PBEParametersGenerator {
    public static final int KEY_MATERIAL = 1;
    public static final int IV_MATERIAL = 2;
    public static final int MAC_MATERIAL = 3;
    private Digest a;
    private int b;
    private int c;

    public PKCS12ParametersGenerator(Digest digest) {
        this.a = digest;
        if (!(digest instanceof ExtendedDigest)) {
            throw new IllegalArgumentException("Digest " + digest.getAlgorithmName() + " unsupported");
        }
        this.b = digest.getDigestSize();
        this.c = ((ExtendedDigest)digest).getByteLength();
    }

    private void a(byte[] byArray, int n2, byte[] byArray2) {
        int n3 = (byArray2[byArray2.length - 1] & 0xFF) + (byArray[n2 + byArray2.length - 1] & 0xFF) + 1;
        byArray[n2 + byArray2.length - 1] = (byte)n3;
        n3 >>>= 8;
        for (int i2 = byArray2.length - 2; i2 >= 0; --i2) {
            byArray[n2 + i2] = (byte)(n3 += (byArray2[i2] & 0xFF) + (byArray[n2 + i2] & 0xFF));
            n3 >>>= 8;
        }
    }

    private byte[] a(int n2, int n3) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3 = new byte[this.c];
        byte[] byArray4 = new byte[n3];
        for (int i2 = 0; i2 != byArray3.length; ++i2) {
            byArray3[i2] = (byte)n2;
        }
        if (this.salt != null && this.salt.length != 0) {
            byArray2 = new byte[this.c * ((this.salt.length + this.c - 1) / this.c)];
            for (int i3 = 0; i3 != byArray2.length; ++i3) {
                byArray2[i3] = this.salt[i3 % this.salt.length];
            }
        } else {
            byArray2 = new byte[]{};
        }
        if (this.password != null && this.password.length != 0) {
            byArray = new byte[this.c * ((this.password.length + this.c - 1) / this.c)];
            for (int i4 = 0; i4 != byArray.length; ++i4) {
                byArray[i4] = this.password[i4 % this.password.length];
            }
        } else {
            byArray = new byte[]{};
        }
        byte[] byArray5 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray5, byArray2.length, byArray.length);
        byte[] byArray6 = new byte[this.c];
        int n4 = (n3 + this.b - 1) / this.b;
        byte[] byArray7 = new byte[this.b];
        for (int i5 = 1; i5 <= n4; ++i5) {
            int n5;
            this.a.update(byArray3, 0, byArray3.length);
            this.a.update(byArray5, 0, byArray5.length);
            this.a.doFinal(byArray7, 0);
            for (n5 = 1; n5 < this.iterationCount; ++n5) {
                this.a.update(byArray7, 0, byArray7.length);
                this.a.doFinal(byArray7, 0);
            }
            for (n5 = 0; n5 != byArray6.length; ++n5) {
                byArray6[n5] = byArray7[n5 % byArray7.length];
            }
            for (n5 = 0; n5 != byArray5.length / this.c; ++n5) {
                this.a(byArray5, n5 * this.c, byArray6);
            }
            if (i5 == n4) {
                System.arraycopy(byArray7, 0, byArray4, (i5 - 1) * this.b, byArray4.length - (i5 - 1) * this.b);
                continue;
            }
            System.arraycopy(byArray7, 0, byArray4, (i5 - 1) * this.b, byArray7.length);
        }
        return byArray4;
    }

    @Override
    public CipherParameters generateDerivedParameters(int n2) {
        byte[] byArray = this.a(1, n2 /= 8);
        return new KeyParameter(byArray, 0, n2);
    }

    @Override
    public CipherParameters generateDerivedParameters(int n2, int n3) {
        byte[] byArray = this.a(1, n2 /= 8);
        byte[] byArray2 = this.a(2, n3 /= 8);
        return new ParametersWithIV(new KeyParameter(byArray, 0, n2), byArray2, 0, n3);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int n2) {
        byte[] byArray = this.a(3, n2 /= 8);
        return new KeyParameter(byArray, 0, n2);
    }
}

