/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert.ocsp;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Exception;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OutputStream;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.OCSPRequest;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.Request;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Certificate;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.cad.internal.bouncycastle.cert.CertIOException;
import com.aspose.cad.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.OCSPException;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.Req;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.a;
import com.aspose.cad.internal.bouncycastle.operator.ContentVerifier;
import com.aspose.cad.internal.bouncycastle.operator.ContentVerifierProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;

public class OCSPReq {
    private static final X509CertificateHolder[] a = new X509CertificateHolder[0];
    private OCSPRequest b;
    private Extensions c;

    public OCSPReq(OCSPRequest oCSPRequest) {
        this.b = oCSPRequest;
        this.c = oCSPRequest.getTbsRequest().getRequestExtensions();
    }

    public OCSPReq(byte[] byArray) throws IOException {
        this(new ASN1InputStream(byArray));
    }

    private OCSPReq(ASN1InputStream aSN1InputStream) throws IOException {
        try {
            this.b = OCSPRequest.getInstance(aSN1InputStream.readObject());
            if (this.b == null) {
                throw new CertIOException("malformed request: no request data found");
            }
            this.c = this.b.getTbsRequest().getRequestExtensions();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed request: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed request: " + classCastException.getMessage(), classCastException);
        }
        catch (ASN1Exception aSN1Exception) {
            throw new CertIOException("malformed request: " + aSN1Exception.getMessage(), aSN1Exception);
        }
    }

    public int getVersionNumber() {
        return this.b.getTbsRequest().getVersion().getValue().intValue() + 1;
    }

    public GeneralName getRequestorName() {
        return GeneralName.getInstance(this.b.getTbsRequest().getRequestorName());
    }

    public Req[] getRequestList() {
        ASN1Sequence aSN1Sequence = this.b.getTbsRequest().getRequestList();
        Req[] reqArray = new Req[aSN1Sequence.size()];
        for (int i2 = 0; i2 != reqArray.length; ++i2) {
            reqArray[i2] = new Req(Request.getInstance(aSN1Sequence.getObjectAt(i2)));
        }
        return reqArray;
    }

    public boolean hasExtensions() {
        return this.c != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.c != null) {
            return this.c.getExtension(aSN1ObjectIdentifier);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return com.aspose.cad.internal.bouncycastle.cert.ocsp.a.c(this.c);
    }

    public Set getCriticalExtensionOIDs() {
        return com.aspose.cad.internal.bouncycastle.cert.ocsp.a.a(this.c);
    }

    public Set getNonCriticalExtensionOIDs() {
        return com.aspose.cad.internal.bouncycastle.cert.ocsp.a.b(this.c);
    }

    public ASN1ObjectIdentifier getSignatureAlgOID() {
        if (!this.isSigned()) {
            return null;
        }
        return this.b.getOptionalSignature().getSignatureAlgorithm().getAlgorithm();
    }

    public byte[] getSignature() {
        if (!this.isSigned()) {
            return null;
        }
        return this.b.getOptionalSignature().getSignature().getOctets();
    }

    public X509CertificateHolder[] getCerts() {
        if (this.b.getOptionalSignature() != null) {
            ASN1Sequence aSN1Sequence = this.b.getOptionalSignature().getCerts();
            if (aSN1Sequence != null) {
                X509CertificateHolder[] x509CertificateHolderArray = new X509CertificateHolder[aSN1Sequence.size()];
                for (int i2 = 0; i2 != x509CertificateHolderArray.length; ++i2) {
                    x509CertificateHolderArray[i2] = new X509CertificateHolder(Certificate.getInstance(aSN1Sequence.getObjectAt(i2)));
                }
                return x509CertificateHolderArray;
            }
            return a;
        }
        return a;
    }

    public boolean isSigned() {
        return this.b.getOptionalSignature() != null;
    }

    public boolean isSignatureValid(ContentVerifierProvider contentVerifierProvider) throws OCSPException {
        if (!this.isSigned()) {
            throw new OCSPException("attempt to verify signature on unsigned object");
        }
        try {
            ContentVerifier contentVerifier = contentVerifierProvider.get(this.b.getOptionalSignature().getSignatureAlgorithm());
            OutputStream outputStream = contentVerifier.getOutputStream();
            outputStream.write(this.b.getTbsRequest().getEncoded("DER"));
            return contentVerifier.verify(this.getSignature());
        }
        catch (Exception exception) {
            throw new OCSPException("exception processing signature: " + exception, exception);
        }
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(this.b);
        return byteArrayOutputStream.toByteArray();
    }
}

