/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Time;
import com.aspose.cad.internal.bouncycastle.asn1.x509.V1TBSCertificateGenerator;
import com.aspose.cad.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.cad.internal.bouncycastle.cert.a;
import com.aspose.cad.internal.bouncycastle.operator.ContentSigner;
import java.math.BigInteger;
import java.util.Date;
import java.util.Locale;

public class X509v1CertificateBuilder {
    private V1TBSCertificateGenerator a;

    public X509v1CertificateBuilder(X500Name x500Name, BigInteger bigInteger, Date date, Date date2, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this(x500Name, bigInteger, new Time(date), new Time(date2), x500Name2, subjectPublicKeyInfo);
    }

    public X509v1CertificateBuilder(X500Name x500Name, BigInteger bigInteger, Date date, Date date2, Locale locale, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this(x500Name, bigInteger, new Time(date, locale), new Time(date2, locale), x500Name2, subjectPublicKeyInfo);
    }

    public X509v1CertificateBuilder(X500Name x500Name, BigInteger bigInteger, Time time, Time time2, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        if (x500Name == null) {
            throw new IllegalArgumentException("issuer must not be null");
        }
        if (subjectPublicKeyInfo == null) {
            throw new IllegalArgumentException("publicKeyInfo must not be null");
        }
        this.a = new V1TBSCertificateGenerator();
        this.a.setSerialNumber(new ASN1Integer(bigInteger));
        this.a.setIssuer(x500Name);
        this.a.setStartDate(time);
        this.a.setEndDate(time2);
        this.a.setSubject(x500Name2);
        this.a.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
    }

    public X509CertificateHolder build(ContentSigner contentSigner) {
        this.a.setSignature(contentSigner.getAlgorithmIdentifier());
        return com.aspose.cad.internal.bouncycastle.cert.a.a(contentSigner, this.a.generateTBSCertificate());
    }
}

