/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.x509.qualified;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import java.math.BigInteger;
import java.util.Enumeration;

public class MonetaryValue
extends ASN1Object {
    private Iso4217CurrencyCode a;
    private ASN1Integer b;
    private ASN1Integer c;

    public static MonetaryValue getInstance(Object object) {
        if (object instanceof MonetaryValue) {
            return (MonetaryValue)object;
        }
        if (object != null) {
            return new MonetaryValue(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private MonetaryValue(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.a = Iso4217CurrencyCode.getInstance(enumeration.nextElement());
        this.b = ASN1Integer.getInstance(enumeration.nextElement());
        this.c = ASN1Integer.getInstance(enumeration.nextElement());
    }

    public MonetaryValue(Iso4217CurrencyCode iso4217CurrencyCode, int n2, int n3) {
        this.a = iso4217CurrencyCode;
        this.b = new ASN1Integer(n2);
        this.c = new ASN1Integer(n3);
    }

    public Iso4217CurrencyCode getCurrency() {
        return this.a;
    }

    public BigInteger getAmount() {
        return this.b.getValue();
    }

    public BigInteger getExponent() {
        return this.c.getValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

