/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.x509;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1UTCTime;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.CRLReason;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.cad.internal.bouncycastle.asn1.x509.TBSCertList;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Time;
import com.aspose.cad.internal.bouncycastle.asn1.x509.X509Extensions;
import com.aspose.cad.internal.bouncycastle.asn1.x509.X509Name;
import java.io.IOException;

public class V2TBSCertListGenerator {
    private ASN1Integer a = new ASN1Integer(1L);
    private AlgorithmIdentifier b;
    private X500Name c;
    private Time d;
    private Time e = null;
    private Extensions f = null;
    private ASN1EncodableVector g = new ASN1EncodableVector();
    private static final ASN1Sequence[] h = new ASN1Sequence[11];

    public void setSignature(AlgorithmIdentifier algorithmIdentifier) {
        this.b = algorithmIdentifier;
    }

    public void setIssuer(X509Name x509Name) {
        this.c = X500Name.getInstance(x509Name.toASN1Primitive());
    }

    public void setIssuer(X500Name x500Name) {
        this.c = x500Name;
    }

    public void setThisUpdate(ASN1UTCTime aSN1UTCTime) {
        this.d = new Time(aSN1UTCTime);
    }

    public void setNextUpdate(ASN1UTCTime aSN1UTCTime) {
        this.e = new Time(aSN1UTCTime);
    }

    public void setThisUpdate(Time time) {
        this.d = time;
    }

    public void setNextUpdate(Time time) {
        this.e = time;
    }

    public void addCRLEntry(ASN1Sequence aSN1Sequence) {
        this.g.add(aSN1Sequence);
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, ASN1UTCTime aSN1UTCTime, int n2) {
        this.addCRLEntry(aSN1Integer, new Time(aSN1UTCTime), n2);
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, Time time, int n2) {
        this.addCRLEntry(aSN1Integer, time, n2, null);
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, Time time, int n2, ASN1GeneralizedTime aSN1GeneralizedTime) {
        if (n2 != 0) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            if (n2 < h.length) {
                if (n2 < 0) {
                    throw new IllegalArgumentException("invalid reason value: " + n2);
                }
                aSN1EncodableVector.add(h[n2]);
            } else {
                aSN1EncodableVector.add(V2TBSCertListGenerator.a(n2));
            }
            if (aSN1GeneralizedTime != null) {
                aSN1EncodableVector.add(V2TBSCertListGenerator.a(aSN1GeneralizedTime));
            }
            this.a(aSN1Integer, time, new DERSequence(aSN1EncodableVector));
        } else if (aSN1GeneralizedTime != null) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(V2TBSCertListGenerator.a(aSN1GeneralizedTime));
            this.a(aSN1Integer, time, new DERSequence(aSN1EncodableVector));
        } else {
            this.addCRLEntry(aSN1Integer, time, null);
        }
    }

    private void a(ASN1Integer aSN1Integer, Time time, ASN1Sequence aSN1Sequence) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(aSN1Integer);
        aSN1EncodableVector.add(time);
        if (aSN1Sequence != null) {
            aSN1EncodableVector.add(aSN1Sequence);
        }
        this.addCRLEntry(new DERSequence(aSN1EncodableVector));
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, Time time, Extensions extensions) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(aSN1Integer);
        aSN1EncodableVector.add(time);
        if (extensions != null) {
            aSN1EncodableVector.add(extensions);
        }
        this.addCRLEntry(new DERSequence(aSN1EncodableVector));
    }

    public void setExtensions(X509Extensions x509Extensions) {
        this.setExtensions(Extensions.getInstance(x509Extensions));
    }

    public void setExtensions(Extensions extensions) {
        this.f = extensions;
    }

    public TBSCertList generateTBSCertList() {
        if (this.b == null || this.c == null || this.d == null) {
            throw new IllegalStateException("Not all mandatory fields set in V2 TBSCertList generator.");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        if (this.e != null) {
            aSN1EncodableVector.add(this.e);
        }
        if (this.g.size() != 0) {
            aSN1EncodableVector.add(new DERSequence(this.g));
        }
        if (this.f != null) {
            aSN1EncodableVector.add(new DERTaggedObject(0, this.f));
        }
        return new TBSCertList(new DERSequence(aSN1EncodableVector));
    }

    private static ASN1Sequence a(int n2) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        CRLReason cRLReason = CRLReason.lookup(n2);
        try {
            aSN1EncodableVector.add(Extension.reasonCode);
            aSN1EncodableVector.add(new DEROctetString(cRLReason.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error encoding reason: " + iOException);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    private static ASN1Sequence a(ASN1GeneralizedTime aSN1GeneralizedTime) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            aSN1EncodableVector.add(Extension.invalidityDate);
            aSN1EncodableVector.add(new DEROctetString(aSN1GeneralizedTime.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error encoding reason: " + iOException);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    static {
        V2TBSCertListGenerator.h[0] = V2TBSCertListGenerator.a(0);
        V2TBSCertListGenerator.h[1] = V2TBSCertListGenerator.a(1);
        V2TBSCertListGenerator.h[2] = V2TBSCertListGenerator.a(2);
        V2TBSCertListGenerator.h[3] = V2TBSCertListGenerator.a(3);
        V2TBSCertListGenerator.h[4] = V2TBSCertListGenerator.a(4);
        V2TBSCertListGenerator.h[5] = V2TBSCertListGenerator.a(5);
        V2TBSCertListGenerator.h[6] = V2TBSCertListGenerator.a(6);
        V2TBSCertListGenerator.h[7] = V2TBSCertListGenerator.a(7);
        V2TBSCertListGenerator.h[8] = V2TBSCertListGenerator.a(8);
        V2TBSCertListGenerator.h[9] = V2TBSCertListGenerator.a(9);
        V2TBSCertListGenerator.h[10] = V2TBSCertListGenerator.a(10);
    }
}

