/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.operator.jcajce;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.operator.AsymmetricKeyUnwrapper;
import com.aspose.cad.internal.bouncycastle.operator.GenericKey;
import com.aspose.cad.internal.bouncycastle.operator.OperatorException;
import com.aspose.cad.internal.bouncycastle.operator.jcajce.JceGenericKey;
import com.aspose.cad.internal.bouncycastle.operator.jcajce.h;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;

public class JceAsymmetricKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private h a = new h(new DefaultJcaJceHelper());
    private Map b = new HashMap();
    private PrivateKey c;
    private boolean d;

    public JceAsymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privateKey) {
        super(algorithmIdentifier);
        this.c = privateKey;
    }

    public JceAsymmetricKeyUnwrapper setProvider(Provider provider) {
        this.a = new h(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceAsymmetricKeyUnwrapper setProvider(String string) {
        this.a = new h(new NamedJcaJceHelper(string));
        return this;
    }

    public JceAsymmetricKeyUnwrapper setMustProduceEncodableUnwrappedKey(boolean bl2) {
        this.d = bl2;
        return this;
    }

    public JceAsymmetricKeyUnwrapper setAlgorithmMapping(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        this.b.put(aSN1ObjectIdentifier, string);
        return this;
    }

    @Override
    public GenericKey generateUnwrappedKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws OperatorException {
        try {
            Cipher cipher;
            Key key;
            block15: {
                key = null;
                cipher = this.a.a(this.getAlgorithmIdentifier().getAlgorithm(), this.b);
                AlgorithmParameters algorithmParameters = this.a.a(this.getAlgorithmIdentifier());
                try {
                    if (algorithmParameters != null) {
                        cipher.init(4, (Key)this.c, algorithmParameters);
                    } else {
                        cipher.init(4, this.c);
                    }
                    key = cipher.unwrap(byArray, this.a.d(algorithmIdentifier.getAlgorithm()), 3);
                    if (!this.d) break block15;
                    try {
                        byte[] byArray2 = key.getEncoded();
                        if (byArray2 == null || byArray2.length == 0) {
                            key = null;
                        }
                    }
                    catch (Exception exception) {
                        key = null;
                    }
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (ProviderException providerException) {
                    // empty catch block
                }
            }
            if (key == null) {
                cipher.init(2, this.c);
                key = new SecretKeySpec(cipher.doFinal(byArray), algorithmIdentifier.getAlgorithm().getId());
            }
            return new JceGenericKey(algorithmIdentifier, key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new OperatorException("key invalid: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new OperatorException("illegal blocksize: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new OperatorException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
        }
    }
}

