/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.operator.bc;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.cad.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.cad.internal.bouncycastle.operator.AsymmetricKeyUnwrapper;
import com.aspose.cad.internal.bouncycastle.operator.GenericKey;
import com.aspose.cad.internal.bouncycastle.operator.OperatorException;

public abstract class BcAsymmetricKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private AsymmetricKeyParameter a;

    public BcAsymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, AsymmetricKeyParameter asymmetricKeyParameter) {
        super(algorithmIdentifier);
        this.a = asymmetricKeyParameter;
    }

    @Override
    public GenericKey generateUnwrappedKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws OperatorException {
        AsymmetricBlockCipher asymmetricBlockCipher = this.createAsymmetricUnwrapper(this.getAlgorithmIdentifier().getAlgorithm());
        asymmetricBlockCipher.init(false, this.a);
        try {
            byte[] byArray2 = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
            if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.des_EDE3_CBC)) {
                return new GenericKey(algorithmIdentifier, byArray2);
            }
            return new GenericKey(algorithmIdentifier, byArray2);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new OperatorException("unable to recover secret key: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    protected abstract AsymmetricBlockCipher createAsymmetricUnwrapper(ASN1ObjectIdentifier var1);
}

