/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.params;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.DHValidationParameters;
import java.math.BigInteger;

public class DHParameters
implements CipherParameters {
    private static final int a = 160;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private int f;
    private int g;
    private DHValidationParameters h;

    private static int a(int n2) {
        if (n2 == 0) {
            return 160;
        }
        return n2 < 160 ? n2 : 160;
    }

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, bigInteger2, null, 0);
    }

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) {
        this(bigInteger, bigInteger2, bigInteger3, DHParameters.a(n2), n2, null, null);
    }

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2, int n3) {
        this(bigInteger, bigInteger2, bigInteger3, n2, n3, null, null);
    }

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, DHValidationParameters dHValidationParameters) {
        this(bigInteger, bigInteger2, bigInteger3, 160, 0, bigInteger4, dHValidationParameters);
    }

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2, int n3, BigInteger bigInteger4, DHValidationParameters dHValidationParameters) {
        if (n3 != 0) {
            if (n3 > bigInteger.bitLength()) {
                throw new IllegalArgumentException("when l value specified, it must satisfy 2^(l-1) <= p");
            }
            if (n3 < n2) {
                throw new IllegalArgumentException("when l value specified, it may not be less than m value");
            }
        }
        if (n2 > bigInteger.bitLength()) {
            throw new IllegalArgumentException("unsafe p value so small specific l required");
        }
        this.b = bigInteger2;
        this.c = bigInteger;
        this.d = bigInteger3;
        this.f = n2;
        this.g = n3;
        this.e = bigInteger4;
        this.h = dHValidationParameters;
    }

    public BigInteger getP() {
        return this.c;
    }

    public BigInteger getG() {
        return this.b;
    }

    public BigInteger getQ() {
        return this.d;
    }

    public BigInteger getJ() {
        return this.e;
    }

    public int getM() {
        return this.f;
    }

    public int getL() {
        return this.g;
    }

    public DHValidationParameters getValidationParameters() {
        return this.h;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DHParameters)) {
            return false;
        }
        DHParameters dHParameters = (DHParameters)object;
        if (this.getQ() != null ? !this.getQ().equals(dHParameters.getQ()) : dHParameters.getQ() != null) {
            return false;
        }
        return dHParameters.getP().equals(this.c) && dHParameters.getG().equals(this.b);
    }

    public int hashCode() {
        return this.getP().hashCode() ^ this.getG().hashCode() ^ (this.getQ() != null ? this.getQ().hashCode() : 0);
    }
}

