/*
 * Decompiled with CFR 0.152.
 */
package cpdetector.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class SingletonLoader {
    private static SingletonLoader instance = null;
    private Object[] dummyParameters = new Object[0];

    private SingletonLoader() {
    }

    public static SingletonLoader getInstance() {
        if (instance == null) {
            instance = new SingletonLoader();
        }
        return instance;
    }

    public Object newInstance(String fullyQualifiedClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Object ret = this.newInstance(Class.forName(fullyQualifiedClassName));
        return ret;
    }

    public Object newInstance(Class c) throws InstantiationException, IllegalAccessException {
        int modifiers;
        Object ret = null;
        Method[] methods = c.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            modifiers = m.getModifiers();
            if ((modifiers & 8) == 0 || (modifiers & 1) == 0 || m.getParameterTypes().length != 0 || m.getReturnType() != c || m.getName().toLowerCase().indexOf("instance") == -1) continue;
            try {
                ret = m.invoke(null, this.dummyParameters);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (ret == null) {
            Constructor<?>[] constructors = c.getConstructors();
            Constructor<?> con = null;
            for (int i = 0; i < constructors.length; ++i) {
                con = constructors[i];
                if (con.getParameterTypes().length != 0) continue;
                modifiers = con.getModifiers();
                try {
                    if ((modifiers & 1) == 0) {
                        con.setAccessible(true);
                    }
                    ret = c.newInstance();
                    continue;
                }
                catch (SecurityException se) {
                    // empty catch block
                }
            }
        }
        if (ret == null) {
            System.err.println("Unable to instantiate: " + c.getName() + ": no singleton method, no public default constructor.");
        }
        return ret;
    }
}

