/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric;

import com.aspose.cad.internal.bouncycastle.crypto.BufferedBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherKeyGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.engines.GOST3412_2015Engine;
import com.aspose.cad.internal.bouncycastle.crypto.macs.CMac;
import com.aspose.cad.internal.bouncycastle.crypto.modes.G3413CBCBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.modes.G3413CFBBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.modes.G3413CTRBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.modes.G3413OFBBlockCipher;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public class GOST3412_2015 {

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new G3413CBCBlockCipher(new GOST3412_2015Engine()), false, 128);
        }
    }

    public static class CTR
    extends BaseBlockCipher {
        public CTR() {
            super(new BufferedBlockCipher(new G3413CTRBlockCipher(new GOST3412_2015Engine())), 128);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new GOST3412_2015Engine());
        }
    }

    public static class GCFB
    extends BaseBlockCipher {
        public GCFB() {
            super(new BufferedBlockCipher(new G3413CFBBlockCipher(new GOST3412_2015Engine())), false, 128);
        }
    }

    public static class GCFB8
    extends BaseBlockCipher {
        public GCFB8() {
            super(new BufferedBlockCipher(new G3413CFBBlockCipher(new GOST3412_2015Engine(), 8)), false, 128);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            this(256);
        }

        public KeyGen(int n2) {
            super("GOST3412-2015", n2, new CipherKeyGenerator());
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            super(new CMac(new GOST3412_2015Engine()));
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String a = GOST3412_2015.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.GOST3412-2015", a + "$ECB");
            configurableProvider.addAlgorithm("Cipher.GOST3412-2015/CFB", a + "$GCFB");
            configurableProvider.addAlgorithm("Cipher.GOST3412-2015/CFB8", a + "$GCFB8");
            configurableProvider.addAlgorithm("Cipher.GOST3412-2015/OFB", a + "$OFB");
            configurableProvider.addAlgorithm("Cipher.GOST3412-2015/CBC", a + "$CBC");
            configurableProvider.addAlgorithm("Cipher.GOST3412-2015/CTR", a + "$CTR");
            configurableProvider.addAlgorithm("KeyGenerator.GOST3412-2015", a + "$KeyGen");
            configurableProvider.addAlgorithm("Mac.GOST3412MAC", a + "$Mac");
            configurableProvider.addAlgorithm("Alg.Alias.Mac.GOST3412-2015", "GOST3412MAC");
        }
    }

    public static class OFB
    extends BaseBlockCipher {
        public OFB() {
            super(new BufferedBlockCipher(new G3413OFBBlockCipher(new GOST3412_2015Engine())), false, 128);
        }
    }
}

