/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.x9;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9Curve;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9ECPoint;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9FieldID;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.math.ec.ECAlgorithms;
import com.aspose.cad.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.cad.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.cad.internal.bouncycastle.math.field.PolynomialExtensionField;
import java.math.BigInteger;

public class X9ECParameters
extends ASN1Object
implements X9ObjectIdentifiers {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private X9FieldID b;
    private ECCurve c;
    private X9ECPoint d;
    private BigInteger e;
    private BigInteger f;
    private byte[] g;

    private X9ECParameters(ASN1Sequence aSN1Sequence) {
        if (!(aSN1Sequence.getObjectAt(0) instanceof ASN1Integer) || !((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue().equals(a)) {
            throw new IllegalArgumentException("bad version in X9ECParameters");
        }
        X9Curve x9Curve = new X9Curve(X9FieldID.getInstance(aSN1Sequence.getObjectAt(1)), ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(2)));
        this.c = x9Curve.getCurve();
        ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(3);
        this.d = aSN1Encodable instanceof X9ECPoint ? (X9ECPoint)aSN1Encodable : new X9ECPoint(this.c, (ASN1OctetString)aSN1Encodable);
        this.e = ((ASN1Integer)aSN1Sequence.getObjectAt(4)).getValue();
        this.g = x9Curve.getSeed();
        if (aSN1Sequence.size() == 6) {
            this.f = ((ASN1Integer)aSN1Sequence.getObjectAt(5)).getValue();
        }
    }

    public static X9ECParameters getInstance(Object object) {
        if (object instanceof X9ECParameters) {
            return (X9ECParameters)object;
        }
        if (object != null) {
            return new X9ECParameters(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public X9ECParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger) {
        this(eCCurve, eCPoint, bigInteger, null, null);
    }

    public X9ECParameters(ECCurve eCCurve, X9ECPoint x9ECPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        this(eCCurve, x9ECPoint, bigInteger, bigInteger2, null);
    }

    public X9ECParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        this(eCCurve, eCPoint, bigInteger, bigInteger2, null);
    }

    public X9ECParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        this(eCCurve, new X9ECPoint(eCPoint), bigInteger, bigInteger2, byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public X9ECParameters(ECCurve eCCurve, X9ECPoint x9ECPoint, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        this.c = eCCurve;
        this.d = x9ECPoint;
        this.e = bigInteger;
        this.f = bigInteger2;
        this.g = byArray;
        if (ECAlgorithms.isFpCurve(eCCurve)) {
            this.b = new X9FieldID(eCCurve.getField().getCharacteristic());
            return;
        } else {
            if (!ECAlgorithms.isF2mCurve(eCCurve)) throw new IllegalArgumentException("'curve' is of an unsupported type");
            PolynomialExtensionField polynomialExtensionField = (PolynomialExtensionField)eCCurve.getField();
            int[] nArray = polynomialExtensionField.getMinimalPolynomial().getExponentsPresent();
            if (nArray.length == 3) {
                this.b = new X9FieldID(nArray[2], nArray[1]);
                return;
            } else {
                if (nArray.length != 5) throw new IllegalArgumentException("Only trinomial and pentomial curves are supported");
                this.b = new X9FieldID(nArray[4], nArray[1], nArray[2], nArray[3]);
            }
        }
    }

    public ECCurve getCurve() {
        return this.c;
    }

    public ECPoint getG() {
        return this.d.getPoint();
    }

    public BigInteger getN() {
        return this.e;
    }

    public BigInteger getH() {
        return this.f;
    }

    public byte[] getSeed() {
        return this.g;
    }

    public X9Curve getCurveEntry() {
        return new X9Curve(this.c, this.g);
    }

    public X9FieldID getFieldIDEntry() {
        return this.b;
    }

    public X9ECPoint getBaseEntry() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(a));
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(new X9Curve(this.c, this.g));
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(new ASN1Integer(this.e));
        if (this.f != null) {
            aSN1EncodableVector.add(new ASN1Integer(this.f));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

