/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.x509;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Target;
import com.aspose.cad.internal.bouncycastle.asn1.x509.TargetInformation;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Targets;
import com.aspose.cad.internal.bouncycastle.asn1.x509.X509Extensions;
import com.aspose.cad.internal.bouncycastle.util.Selector;
import com.aspose.cad.internal.bouncycastle.x509.AttributeCertificateHolder;
import com.aspose.cad.internal.bouncycastle.x509.AttributeCertificateIssuer;
import com.aspose.cad.internal.bouncycastle.x509.X509AttributeCertificate;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class X509AttributeCertStoreSelector
implements Selector {
    private AttributeCertificateHolder a;
    private AttributeCertificateIssuer b;
    private BigInteger c;
    private Date d;
    private X509AttributeCertificate e;
    private Collection f = new HashSet();
    private Collection g = new HashSet();

    public boolean match(Object object) {
        byte[] byArray;
        if (!(object instanceof X509AttributeCertificate)) {
            return false;
        }
        X509AttributeCertificate x509AttributeCertificate = (X509AttributeCertificate)object;
        if (this.e != null && !this.e.equals(x509AttributeCertificate)) {
            return false;
        }
        if (this.c != null && !x509AttributeCertificate.getSerialNumber().equals(this.c)) {
            return false;
        }
        if (this.a != null && !x509AttributeCertificate.getHolder().equals(this.a)) {
            return false;
        }
        if (this.b != null && !x509AttributeCertificate.getIssuer().equals(this.b)) {
            return false;
        }
        if (this.d != null) {
            try {
                x509AttributeCertificate.checkValidity(this.d);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                return false;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                return false;
            }
        }
        if (!(this.f.isEmpty() && this.g.isEmpty() || (byArray = x509AttributeCertificate.getExtensionValue(X509Extensions.TargetInformation.getId())) == null)) {
            int n2;
            Target[] targetArray;
            Targets targets;
            int n3;
            boolean bl2;
            TargetInformation targetInformation;
            try {
                targetInformation = TargetInformation.getInstance(new ASN1InputStream(((DEROctetString)DEROctetString.fromByteArray(byArray)).getOctets()).readObject());
            }
            catch (IOException iOException) {
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            Targets[] targetsArray = targetInformation.getTargetsObjects();
            if (!this.f.isEmpty()) {
                bl2 = false;
                block6: for (n3 = 0; n3 < targetsArray.length; ++n3) {
                    targets = targetsArray[n3];
                    targetArray = targets.getTargets();
                    for (n2 = 0; n2 < targetArray.length; ++n2) {
                        if (!this.f.contains(GeneralName.getInstance(targetArray[n2].getTargetName()))) continue;
                        bl2 = true;
                        continue block6;
                    }
                }
                if (!bl2) {
                    return false;
                }
            }
            if (!this.g.isEmpty()) {
                bl2 = false;
                block8: for (n3 = 0; n3 < targetsArray.length; ++n3) {
                    targets = targetsArray[n3];
                    targetArray = targets.getTargets();
                    for (n2 = 0; n2 < targetArray.length; ++n2) {
                        if (!this.g.contains(GeneralName.getInstance(targetArray[n2].getTargetGroup()))) continue;
                        bl2 = true;
                        continue block8;
                    }
                }
                if (!bl2) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Object clone() {
        X509AttributeCertStoreSelector x509AttributeCertStoreSelector = new X509AttributeCertStoreSelector();
        x509AttributeCertStoreSelector.e = this.e;
        x509AttributeCertStoreSelector.d = this.getAttributeCertificateValid();
        x509AttributeCertStoreSelector.a = this.a;
        x509AttributeCertStoreSelector.b = this.b;
        x509AttributeCertStoreSelector.c = this.c;
        x509AttributeCertStoreSelector.g = this.getTargetGroups();
        x509AttributeCertStoreSelector.f = this.getTargetNames();
        return x509AttributeCertStoreSelector;
    }

    public X509AttributeCertificate getAttributeCert() {
        return this.e;
    }

    public void setAttributeCert(X509AttributeCertificate x509AttributeCertificate) {
        this.e = x509AttributeCertificate;
    }

    public Date getAttributeCertificateValid() {
        if (this.d != null) {
            return new Date(this.d.getTime());
        }
        return null;
    }

    public void setAttributeCertificateValid(Date date) {
        this.d = date != null ? new Date(date.getTime()) : null;
    }

    public AttributeCertificateHolder getHolder() {
        return this.a;
    }

    public void setHolder(AttributeCertificateHolder attributeCertificateHolder) {
        this.a = attributeCertificateHolder;
    }

    public AttributeCertificateIssuer getIssuer() {
        return this.b;
    }

    public void setIssuer(AttributeCertificateIssuer attributeCertificateIssuer) {
        this.b = attributeCertificateIssuer;
    }

    public BigInteger getSerialNumber() {
        return this.c;
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.c = bigInteger;
    }

    public void addTargetName(GeneralName generalName) {
        this.f.add(generalName);
    }

    public void addTargetName(byte[] byArray) throws IOException {
        this.addTargetName(GeneralName.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    public void setTargetNames(Collection collection) throws IOException {
        this.f = this.a(collection);
    }

    public Collection getTargetNames() {
        return Collections.unmodifiableCollection(this.f);
    }

    public void addTargetGroup(GeneralName generalName) {
        this.g.add(generalName);
    }

    public void addTargetGroup(byte[] byArray) throws IOException {
        this.addTargetGroup(GeneralName.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    public void setTargetGroups(Collection collection) throws IOException {
        this.g = this.a(collection);
    }

    public Collection getTargetGroups() {
        return Collections.unmodifiableCollection(this.g);
    }

    private Set a(Collection collection) throws IOException {
        if (collection == null || collection.isEmpty()) {
            return new HashSet();
        }
        HashSet hashSet = new HashSet();
        for (Object e2 : collection) {
            if (e2 instanceof GeneralName) {
                hashSet.add(e2);
                continue;
            }
            hashSet.add(GeneralName.getInstance(ASN1Primitive.fromByteArray((byte[])e2)));
        }
        return hashSet;
    }
}

