/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.cad.internal.bouncycastle.asn1.x509.ExtensionsGenerator;
import com.aspose.cad.internal.bouncycastle.asn1.x509.TBSCertList;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Time;
import com.aspose.cad.internal.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import com.aspose.cad.internal.bouncycastle.cert.CertIOException;
import com.aspose.cad.internal.bouncycastle.cert.X509CRLHolder;
import com.aspose.cad.internal.bouncycastle.cert.a;
import com.aspose.cad.internal.bouncycastle.operator.ContentSigner;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;

public class X509v2CRLBuilder {
    private V2TBSCertListGenerator a = new V2TBSCertListGenerator();
    private ExtensionsGenerator b = new ExtensionsGenerator();

    public X509v2CRLBuilder(X500Name x500Name, Date date) {
        this.a.setIssuer(x500Name);
        this.a.setThisUpdate(new Time(date));
    }

    public X509v2CRLBuilder(X500Name x500Name, Date date, Locale locale) {
        this.a.setIssuer(x500Name);
        this.a.setThisUpdate(new Time(date, locale));
    }

    public X509v2CRLBuilder(X500Name x500Name, Time time) {
        this.a.setIssuer(x500Name);
        this.a.setThisUpdate(time);
    }

    public X509v2CRLBuilder setNextUpdate(Date date) {
        return this.setNextUpdate(new Time(date));
    }

    public X509v2CRLBuilder setNextUpdate(Date date, Locale locale) {
        return this.setNextUpdate(new Time(date, locale));
    }

    public X509v2CRLBuilder setNextUpdate(Time time) {
        this.a.setNextUpdate(time);
        return this;
    }

    public X509v2CRLBuilder addCRLEntry(BigInteger bigInteger, Date date, int n2) {
        this.a.addCRLEntry(new ASN1Integer(bigInteger), new Time(date), n2);
        return this;
    }

    public X509v2CRLBuilder addCRLEntry(BigInteger bigInteger, Date date, int n2, Date date2) {
        this.a.addCRLEntry(new ASN1Integer(bigInteger), new Time(date), n2, new ASN1GeneralizedTime(date2));
        return this;
    }

    public X509v2CRLBuilder addCRLEntry(BigInteger bigInteger, Date date, Extensions extensions) {
        this.a.addCRLEntry(new ASN1Integer(bigInteger), new Time(date), extensions);
        return this;
    }

    public X509v2CRLBuilder addCRL(X509CRLHolder x509CRLHolder) {
        TBSCertList tBSCertList = x509CRLHolder.toASN1Structure().getTBSCertList();
        if (tBSCertList != null) {
            Enumeration enumeration = tBSCertList.getRevokedCertificateEnumeration();
            while (enumeration.hasMoreElements()) {
                this.a.addCRLEntry(ASN1Sequence.getInstance(((ASN1Encodable)enumeration.nextElement()).toASN1Primitive()));
            }
        }
        return this;
    }

    public X509v2CRLBuilder addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, ASN1Encodable aSN1Encodable) throws CertIOException {
        com.aspose.cad.internal.bouncycastle.cert.a.a(this.b, aSN1ObjectIdentifier, bl2, aSN1Encodable);
        return this;
    }

    public X509v2CRLBuilder addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, byte[] byArray) throws CertIOException {
        this.b.addExtension(aSN1ObjectIdentifier, bl2, byArray);
        return this;
    }

    public X509v2CRLBuilder addExtension(Extension extension) throws CertIOException {
        this.b.addExtension(extension);
        return this;
    }

    public X509CRLHolder build(ContentSigner contentSigner) {
        this.a.setSignature(contentSigner.getAlgorithmIdentifier());
        if (!this.b.isEmpty()) {
            this.a.setExtensions(this.b.generate());
        }
        return com.aspose.cad.internal.bouncycastle.cert.a.a(contentSigner, this.a.generateTBSCertList());
    }
}

