/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.util.io.pem;

import com.aspose.cad.internal.bouncycastle.util.Strings;
import com.aspose.cad.internal.bouncycastle.util.encoders.Base64;
import com.aspose.cad.internal.bouncycastle.util.io.pem.PemHeader;
import com.aspose.cad.internal.bouncycastle.util.io.pem.PemObject;
import com.aspose.cad.internal.bouncycastle.util.io.pem.PemObjectGenerator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class PemWriter
extends BufferedWriter {
    private static final int a = 64;
    private final int b;
    private char[] c = new char[64];

    public PemWriter(Writer writer) {
        super(writer);
        String string = Strings.lineSeparator();
        this.b = string != null ? string.length() : 2;
    }

    public int getOutputSize(PemObject pemObject) {
        int n2 = 2 * (pemObject.getType().length() + 10 + this.b) + 6 + 4;
        if (!pemObject.getHeaders().isEmpty()) {
            for (PemHeader pemHeader : pemObject.getHeaders()) {
                n2 += pemHeader.getName().length() + ": ".length() + pemHeader.getValue().length() + this.b;
            }
            n2 += this.b;
        }
        int n3 = (pemObject.getContent().length + 2) / 3 * 4;
        return n2 += n3 + (n3 + 64 - 1) / 64 * this.b;
    }

    public void writeObject(PemObjectGenerator pemObjectGenerator) throws IOException {
        PemObject pemObject = pemObjectGenerator.generate();
        this.a(pemObject.getType());
        if (!pemObject.getHeaders().isEmpty()) {
            for (PemHeader pemHeader : pemObject.getHeaders()) {
                this.write(pemHeader.getName());
                this.write(": ");
                this.write(pemHeader.getValue());
                this.newLine();
            }
            this.newLine();
        }
        this.a(pemObject.getContent());
        this.b(pemObject.getType());
    }

    private void a(byte[] byArray) throws IOException {
        byArray = Base64.encode(byArray);
        for (int i2 = 0; i2 < byArray.length; i2 += this.c.length) {
            int n2;
            for (n2 = 0; n2 != this.c.length && i2 + n2 < byArray.length; ++n2) {
                this.c[n2] = (char)byArray[i2 + n2];
            }
            this.write(this.c, 0, n2);
            this.newLine();
        }
    }

    private void a(String string) throws IOException {
        this.write("-----BEGIN " + string + "-----");
        this.newLine();
    }

    private void b(String string) throws IOException {
        this.write("-----END " + string + "-----");
        this.newLine();
    }
}

