/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.operator.jcajce;

import com.aspose.cad.internal.bouncycastle.asn1.cms.GenericHybridParameters;
import com.aspose.cad.internal.bouncycastle.asn1.cms.RsaKemParameters;
import com.aspose.cad.internal.bouncycastle.asn1.iso.ISOIECObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.crypto.util.DEROtherInfo;
import com.aspose.cad.internal.bouncycastle.jcajce.spec.KTSParameterSpec;
import com.aspose.cad.internal.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.operator.AsymmetricKeyWrapper;
import com.aspose.cad.internal.bouncycastle.operator.GenericKey;
import com.aspose.cad.internal.bouncycastle.operator.OperatorException;
import com.aspose.cad.internal.bouncycastle.operator.jcajce.JceSymmetricKeyWrapper;
import com.aspose.cad.internal.bouncycastle.operator.jcajce.h;
import com.aspose.cad.internal.bouncycastle.operator.jcajce.i;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import java.security.Key;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.crypto.Cipher;

public class JceKTSKeyWrapper
extends AsymmetricKeyWrapper {
    private final String a;
    private final int b;
    private final byte[] c;
    private final byte[] d;
    private h e = new h(new DefaultJcaJceHelper());
    private PublicKey f;
    private SecureRandom g;

    public JceKTSKeyWrapper(PublicKey publicKey, String string, int n2, byte[] byArray, byte[] byArray2) {
        super(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_rsa_KEM, new GenericHybridParameters(new AlgorithmIdentifier(ISOIECObjectIdentifiers.id_kem_rsa, new RsaKemParameters(new AlgorithmIdentifier(X9ObjectIdentifiers.id_kdf_kdf3, new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256)), (n2 + 7) / 8)), JceSymmetricKeyWrapper.determineKeyEncAlg(string, n2))));
        this.f = publicKey;
        this.a = string;
        this.b = n2;
        this.c = Arrays.clone(byArray);
        this.d = Arrays.clone(byArray2);
    }

    public JceKTSKeyWrapper(X509Certificate x509Certificate, String string, int n2, byte[] byArray, byte[] byArray2) {
        this(x509Certificate.getPublicKey(), string, n2, byArray, byArray2);
    }

    public JceKTSKeyWrapper setProvider(Provider provider) {
        this.e = new h(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKTSKeyWrapper setProvider(String string) {
        this.e = new h(new NamedJcaJceHelper(string));
        return this;
    }

    public JceKTSKeyWrapper setSecureRandom(SecureRandom secureRandom) {
        this.g = secureRandom;
        return this;
    }

    @Override
    public byte[] generateWrappedKey(GenericKey genericKey) throws OperatorException {
        Cipher cipher = this.e.a(this.getAlgorithmIdentifier().getAlgorithm(), new HashMap());
        try {
            DEROtherInfo dEROtherInfo = new DEROtherInfo.Builder(JceSymmetricKeyWrapper.determineKeyEncAlg(this.a, this.b), this.c, this.d).build();
            KTSParameterSpec kTSParameterSpec = new KTSParameterSpec.Builder(this.a, this.b, dEROtherInfo.getEncoded()).build();
            cipher.init(3, (Key)this.f, kTSParameterSpec, this.g);
            return cipher.wrap(i.a(genericKey));
        }
        catch (Exception exception) {
            throw new OperatorException("Unable to wrap contents key: " + exception.getMessage(), exception);
        }
    }
}

