/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.dvcs;

import com.aspose.cad.internal.bouncycastle.asn1.dvcs.DVCSRequestInformation;
import com.aspose.cad.internal.bouncycastle.asn1.dvcs.DVCSTime;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralNames;
import com.aspose.cad.internal.bouncycastle.asn1.x509.PolicyInformation;
import com.aspose.cad.internal.bouncycastle.dvcs.DVCSParsingException;
import com.aspose.cad.internal.bouncycastle.tsp.TimeStampToken;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.util.Date;

public class DVCSRequestInfo {
    private DVCSRequestInformation a;

    public DVCSRequestInfo(byte[] byArray) {
        this(DVCSRequestInformation.getInstance(byArray));
    }

    public DVCSRequestInfo(DVCSRequestInformation dVCSRequestInformation) {
        this.a = dVCSRequestInformation;
    }

    public DVCSRequestInformation toASN1Structure() {
        return this.a;
    }

    public int getVersion() {
        return this.a.getVersion();
    }

    public int getServiceType() {
        return this.a.getService().getValue().intValue();
    }

    public BigInteger getNonce() {
        return this.a.getNonce();
    }

    public Date getRequestTime() throws DVCSParsingException {
        DVCSTime dVCSTime = this.a.getRequestTime();
        if (dVCSTime == null) {
            return null;
        }
        try {
            if (dVCSTime.getGenTime() != null) {
                return dVCSTime.getGenTime().getDate();
            }
            TimeStampToken timeStampToken = new TimeStampToken(dVCSTime.getTimeStampToken());
            return timeStampToken.getTimeStampInfo().getGenTime();
        }
        catch (Exception exception) {
            throw new DVCSParsingException("unable to extract time: " + exception.getMessage(), exception);
        }
    }

    public GeneralNames getRequester() {
        return this.a.getRequester();
    }

    public PolicyInformation getRequestPolicy() {
        if (this.a.getRequestPolicy() != null) {
            return this.a.getRequestPolicy();
        }
        return null;
    }

    public GeneralNames getDVCSNames() {
        return this.a.getDVCS();
    }

    public GeneralNames getDataLocations() {
        return this.a.getDataLocations();
    }

    public static boolean validate(DVCSRequestInfo dVCSRequestInfo, DVCSRequestInfo dVCSRequestInfo2) {
        DVCSRequestInformation dVCSRequestInformation = dVCSRequestInfo.a;
        DVCSRequestInformation dVCSRequestInformation2 = dVCSRequestInfo2.a;
        if (dVCSRequestInformation.getVersion() != dVCSRequestInformation2.getVersion()) {
            return false;
        }
        if (!DVCSRequestInfo.a(dVCSRequestInformation.getService(), dVCSRequestInformation2.getService())) {
            return false;
        }
        if (!DVCSRequestInfo.a(dVCSRequestInformation.getRequestTime(), dVCSRequestInformation2.getRequestTime())) {
            return false;
        }
        if (!DVCSRequestInfo.a(dVCSRequestInformation.getRequestPolicy(), dVCSRequestInformation2.getRequestPolicy())) {
            return false;
        }
        if (!DVCSRequestInfo.a(dVCSRequestInformation.getExtensions(), dVCSRequestInformation2.getExtensions())) {
            return false;
        }
        if (dVCSRequestInformation.getNonce() != null) {
            if (dVCSRequestInformation2.getNonce() == null) {
                return false;
            }
            byte[] byArray = dVCSRequestInformation.getNonce().toByteArray();
            byte[] byArray2 = dVCSRequestInformation2.getNonce().toByteArray();
            if (byArray2.length < byArray.length) {
                return false;
            }
            if (!Arrays.areEqual(byArray, Arrays.copyOfRange(byArray2, 0, byArray.length))) {
                return false;
            }
        }
        return true;
    }

    private static boolean a(Object object, Object object2) {
        return object == null && object2 == null || object != null && object.equals(object2);
    }
}

