/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.params;

import com.aspose.cad.internal.bouncycastle.crypto.DerivationParameters;
import com.aspose.cad.internal.bouncycastle.util.Arrays;

public final class KDFDoublePipelineIterationParameters
implements DerivationParameters {
    private static final int a = 32;
    private final byte[] b;
    private final boolean c;
    private final int d;
    private final byte[] e;

    private KDFDoublePipelineIterationParameters(byte[] byArray, byte[] byArray2, int n2, boolean bl2) {
        if (byArray == null) {
            throw new IllegalArgumentException("A KDF requires Ki (a seed) as input");
        }
        this.b = Arrays.clone(byArray);
        this.e = byArray2 == null ? new byte[0] : Arrays.clone(byArray2);
        if (n2 != 8 && n2 != 16 && n2 != 24 && n2 != 32) {
            throw new IllegalArgumentException("Length of counter should be 8, 16, 24 or 32");
        }
        this.d = n2;
        this.c = bl2;
    }

    public static KDFDoublePipelineIterationParameters createWithCounter(byte[] byArray, byte[] byArray2, int n2) {
        return new KDFDoublePipelineIterationParameters(byArray, byArray2, n2, true);
    }

    public static KDFDoublePipelineIterationParameters createWithoutCounter(byte[] byArray, byte[] byArray2) {
        return new KDFDoublePipelineIterationParameters(byArray, byArray2, 32, false);
    }

    public byte[] getKI() {
        return this.b;
    }

    public boolean useCounter() {
        return this.c;
    }

    public int getR() {
        return this.d;
    }

    public byte[] getFixedInputData() {
        return Arrays.clone(this.e);
    }
}

